/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.reflect.json;

import gw.lang.reflect.json.Token;
import gw.lang.reflect.json.TokenType;
import gw.lang.reflect.json.Tokenizer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.script.SimpleBindings;

final class SimpleParserImpl {
    private final Tokenizer tokenizer;
    private Token T;
    private final List<String> errors;
    private boolean useBig;

    public SimpleParserImpl(Tokenizer tokenizer, boolean useBig) {
        this.tokenizer = tokenizer;
        this.useBig = useBig;
        this.errors = new ArrayList<String>();
        this.advance();
    }

    public void advance() {
        this.T = this.tokenizer.next();
    }

    public boolean hasMore() {
        return this.T.getType() != TokenType.EOF;
    }

    public Token currentToken() {
        return this.T;
    }

    public Object parse() {
        Object val = null;
        if (this.T.isValueType()) {
            val = this.parseValue();
        } else {
            this.addError();
        }
        return val;
    }

    public Object parseArray() {
        ArrayList<Object> arr = new ArrayList<Object>();
        this.advance();
        if (this.T.isValueType()) {
            arr.add(this.parseValue());
            while (this.T.getType() == TokenType.COMMA) {
                this.advance();
                arr.add(this.parseValue());
            }
        }
        this.checkAndSkip(TokenType.RSQUARE, "]");
        return arr;
    }

    public void skipArray() {
        this.advance();
        if (this.T.isValueType()) {
            this.skipValue();
            while (this.T.getType() == TokenType.COMMA) {
                this.advance();
                this.skipValue();
            }
        }
        this.checkAndSkip(TokenType.RSQUARE, "]");
    }

    public Object parseObject() {
        SimpleBindings map = new SimpleBindings();
        this.advance();
        if (this.T.getType() == TokenType.STRING) {
            this.parseMember(map);
            while (this.T.getType() == TokenType.COMMA) {
                this.advance();
                this.parseMember(map);
            }
        }
        this.checkAndSkip(TokenType.RCURLY, "}");
        return map;
    }

    public void skipObject() {
        this.advance();
        if (this.T.getType() == TokenType.STRING) {
            this.skipMember();
            while (this.T.getType() == TokenType.COMMA) {
                this.advance();
                this.skipMember();
            }
        }
        this.checkAndSkip(TokenType.RCURLY, "}");
    }

    public void parseMember(Map map) {
        String key = this.T.getString();
        this.check(TokenType.STRING, "a string");
        this.check(TokenType.COLON, ":");
        Object val = this.parseValue();
        map.put(key, val);
    }

    public void skipMember() {
        this.check(TokenType.STRING, "a string");
        this.check(TokenType.COLON, ":");
        this.skipValue();
    }

    public Object parseValue() {
        Object val;
        switch (this.T.getType()) {
            case LCURLY: {
                val = this.parseObject();
                break;
            }
            case LSQUARE: {
                val = this.parseArray();
                break;
            }
            case INTEGER: {
                if (this.useBig) {
                    val = new BigInteger(this.T.getString());
                } else {
                    try {
                        val = Integer.parseInt(this.T.getString());
                    }
                    catch (NumberFormatException e0) {
                        try {
                            val = Long.parseLong(this.T.getString());
                        }
                        catch (NumberFormatException e1) {
                            val = 0;
                        }
                    }
                }
                this.advance();
                break;
            }
            case DOUBLE: {
                val = this.useBig ? new BigDecimal(this.T.getString()) : Double.valueOf(Double.parseDouble(this.T.getString()));
                this.advance();
                break;
            }
            case STRING: {
                val = this.T.getString();
                this.advance();
                break;
            }
            case TRUE: {
                val = true;
                this.advance();
                break;
            }
            case FALSE: {
                val = false;
                this.advance();
                break;
            }
            case NULL: {
                val = null;
                this.advance();
                break;
            }
            default: {
                val = null;
                this.addError();
            }
        }
        return val;
    }

    public void skipValue() {
        switch (this.T.getType()) {
            case LCURLY: {
                this.skipObject();
                break;
            }
            case LSQUARE: {
                this.skipArray();
                break;
            }
            case INTEGER: 
            case DOUBLE: 
            case STRING: 
            case TRUE: 
            case FALSE: 
            case NULL: {
                this.advance();
                break;
            }
            default: {
                this.addError();
            }
        }
    }

    private void addError() {
        this.errors.add("[" + this.T.getLineNumber() + ":" + this.T.getColumn() + "] Unexpected token '" + this.T.getString() + "'");
        this.advance();
    }

    private void check(TokenType type, String s) {
        if (this.T.getType() != type) {
            this.errors.add("[" + this.T.getLineNumber() + ":" + this.T.getColumn() + "] expecting '" + s + "', found '" + this.T.getString() + "'");
        }
        this.advance();
    }

    private void checkAndSkip(TokenType type, String s) {
        if (this.T.getType() != type) {
            this.errors.add("[" + this.T.getLineNumber() + ":" + this.T.getColumn() + "] expecting '" + s + "', found '" + this.T.getString() + "'");
            while (this.T.getType() != TokenType.EOF && this.T.getType() != type) {
                this.advance();
            }
        }
        this.advance();
    }

    public List<String> getErrors() {
        return this.errors;
    }
}

