/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.init;

import gw.fs.IDirectory;
import gw.fs.IResource;
import gw.fs.jar.IJarFileDirectory;
import gw.lang.Gosu;
import gw.lang.reflect.TypeSystem;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import manifold.internal.host.RuntimeManifoldHost;

public class GosuRuntimeManifoldHost
extends RuntimeManifoldHost {
    public static GosuRuntimeManifoldHost get() {
        return (GosuRuntimeManifoldHost)RuntimeManifoldHost.get();
    }

    public ClassLoader getActualClassLoader() {
        return TypeSystem.getGosuClassLoader().getActualLoader();
    }

    public void init(List<File> sourcepath, List<File> classpath) {
        if (Gosu.bootstrapGosuWhenInitiatedViaClassfile()) {
            TypeSystem.pushModule(TypeSystem.getGlobalModule());
        }
        if (classpath.isEmpty()) {
            classpath = new ArrayList<File>();
        }
        classpath.addAll(this.removeNonFiles(TypeSystem.getGlobalModule().getJavaClassPath()));
        if (sourcepath.isEmpty()) {
            sourcepath = new ArrayList<File>();
        }
        sourcepath.addAll(this.removeNonFiles(TypeSystem.getGlobalModule().getSourcePath()));
        if (!sourcepath.isEmpty()) {
            this.initDirectly(sourcepath, classpath);
            return;
        }
        super.init(sourcepath, classpath);
    }

    private List<File> removeNonFiles(List<IDirectory> dirs) {
        return dirs.stream().filter(IResource::isJavaFile).filter(e -> !this.isIntelliJGeneratedClasspathJar((IDirectory)e)).map(IResource::toJavaFile).collect(Collectors.toList());
    }

    private boolean isIntelliJGeneratedClasspathJar(IDirectory e) {
        if (e instanceof IJarFileDirectory) {
            String name = e.getName();
            return name.startsWith("classpath") && Character.isDigit(name.charAt("classpath".length()));
        }
        return false;
    }
}

