/*
 * Decompiled with CFR 0.152.
 */
package gw.util.perf.objectsize;

import gw.util.Array;
import gw.util.perf.InvocationCounter;
import gw.util.perf.objectsize.DefaultObjectSizeFilter;
import gw.util.perf.objectsize.IObjectSizeFilter;
import gw.util.perf.objectsize.ObjectSize;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Stack;

public class ObjectSizeUtil {
    public static boolean VERBOSE = true;
    private static final String INDENT = "  ";
    private static final IObjectSizeFilter DEFAULT_FILTER = new DefaultObjectSizeFilter();
    private static DecimalFormat decimalFormat = new DecimalFormat("##.#");
    private static final Map primitiveSizes = new IdentityHashMap(){
        {
            this.put(Boolean.TYPE, new Integer(1));
            this.put(Byte.TYPE, new Integer(1));
            this.put(Character.TYPE, new Integer(2));
            this.put(Short.TYPE, new Integer(2));
            this.put(Integer.TYPE, new Integer(4));
            this.put(Float.TYPE, new Integer(4));
            this.put(Double.TYPE, new Integer(8));
            this.put(Long.TYPE, new Integer(8));
        }
    };

    public static int getFieldSize(Class clazz) {
        Integer i = (Integer)primitiveSizes.get(clazz);
        return i != null ? i : ObjectSizeUtil.getPointerSize();
    }

    public static int getPointerSize() {
        return 4;
    }

    public static ObjectSize deepSizeOf(Object obj, IObjectSizeFilter filter, int maxObjects) {
        IdentityHashMap<Object, Object> visited = new IdentityHashMap<Object, Object>();
        Stack<ObjectEntry> stack = new Stack<ObjectEntry>();
        InvocationCounter sizeHistogram = new InvocationCounter(false);
        long result = ObjectSizeUtil.internalSizeOf(new ObjectEntry(obj, "", ""), stack, visited, filter, "");
        sizeHistogram.recordInvocation(obj.getClass().getName(), (int)result);
        int n = 1;
        while (!stack.isEmpty()) {
            ObjectEntry entry = stack.pop();
            long size = ObjectSizeUtil.internalSizeOf(entry, stack, visited, filter, entry.indent);
            result += size;
            sizeHistogram.recordInvocation(entry.object.getClass().getName(), (int)size);
            if (++n < maxObjects) continue;
            return new ObjectSize(result, false);
        }
        visited.clear();
        if (VERBOSE) {
            System.out.println();
            System.out.println("-------------------------------------------------");
            sizeHistogram.print();
        }
        return new ObjectSize(result, true);
    }

    public static ObjectSize deepSizeOf(Object obj) {
        try {
            return ObjectSizeUtil.deepSizeOf(obj, DEFAULT_FILTER, Integer.MAX_VALUE);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean skipObject(Object obj, Map<Object, Object> visited, IObjectSizeFilter filter) {
        return obj == null || visited.containsKey(obj) || filter.skipObject(obj);
    }

    private static boolean skipField(Field field, IObjectSizeFilter filter) {
        return filter.skipField(field);
    }

    private static long getArrayShallowSize(Object obj) {
        long result = 16L;
        int length = Array.getLength(obj);
        if (length != 0) {
            Class<?> arrayElementClazz = obj.getClass().getComponentType();
            result = arrayElementClazz.isPrimitive() ? (result += (long)(length * ObjectSizeUtil.getFieldSize(arrayElementClazz))) : (result += (long)(length * ObjectSizeUtil.getPointerSize()));
        }
        return result;
    }

    private static long internalSizeOf(ObjectEntry entry, Stack<ObjectEntry> stack, Map<Object, Object> visited, IObjectSizeFilter filter, String indent) {
        int i;
        Class<?> clazz;
        Object obj = entry.object;
        if (ObjectSizeUtil.skipObject(obj, visited, filter)) {
            return 0L;
        }
        visited.put(obj, null);
        long result = 0L;
        if (clazz.isArray()) {
            result += ObjectSizeUtil.getArrayShallowSize(obj);
            if (clazz.getName().length() != 2) {
                int length = Array.getLength(obj);
                for (i = length - 1; i >= 0; --i) {
                    Object o = Array.get(obj, i);
                    if (ObjectSizeUtil.skipObject(o, visited, filter)) continue;
                    stack.add(new ObjectEntry(o, indent + INDENT, "[" + i + "]: "));
                }
            }
        } else {
            result = 8L;
            for (clazz = obj.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
                Field[] fields = clazz.getDeclaredFields();
                for (i = 0; i < fields.length; ++i) {
                    if (Modifier.isStatic(fields[i].getModifiers())) continue;
                    Field field = fields[i];
                    result += (long)ObjectSizeUtil.getFieldSize(field.getType());
                    if (field.getType().isPrimitive() || ObjectSizeUtil.skipField(field, filter)) continue;
                    field.setAccessible(true);
                    try {
                        Object objectToAdd = field.get(obj);
                        if (ObjectSizeUtil.skipObject(objectToAdd, visited, filter)) continue;
                        stack.add(new ObjectEntry(objectToAdd, indent + INDENT, field.getName() + ": "));
                        continue;
                    }
                    catch (IllegalAccessException ex) {
                        assert (false);
                        continue;
                    }
                }
            }
        }
        result = ObjectSizeUtil.roundUpToNearestEightBytes(result);
        if (VERBOSE) {
            Object extra = "";
            if (obj instanceof HashMap) {
                try {
                    Method m = obj.getClass().getDeclaredMethod("capacity", new Class[0]);
                    m.setAccessible(true);
                    int capacity = (Integer)m.invoke(obj, new Object[0]);
                    extra = " (" + decimalFormat.format(100.0 * (double)((HashMap)obj).size() / (double)capacity) + "%) ";
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            if (obj instanceof ArrayList) {
                try {
                    Field f = obj.getClass().getDeclaredField("elementData");
                    f.setAccessible(true);
                    int capacity = Array.getLength(f.get(obj));
                    extra = capacity == 0 ? " (empty) " : " (" + decimalFormat.format(100.0 * (double)((ArrayList)obj).size() / (double)capacity) + "%) ";
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            System.out.println(indent + entry.info + obj.getClass().getName() + (String)extra + " - " + result);
        }
        return result;
    }

    private static long roundUpToNearestEightBytes(long result) {
        if (result % 8L != 0L) {
            result += 8L - result % 8L;
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        String[] s = new String[0xB00000];
        System.out.println(ObjectSizeUtil.deepSizeOf(s));
    }

    private static class ObjectEntry {
        public Object object;
        public String indent;
        public String info;

        public ObjectEntry(Object object, String indent, String info) {
            this.object = object;
            this.indent = indent;
            this.info = info;
        }
    }
}

