/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.parser.exceptions;

import gw.lang.parser.IParseIssue;
import gw.lang.parser.IParsedElement;
import gw.lang.parser.resources.ResourceKey;
import gw.lang.parser.statements.IClassStatement;
import gw.lang.reflect.IFunctionType;
import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeLoader;
import gw.lang.reflect.gs.ICompilableType;
import java.util.ArrayList;
import java.util.List;

public class ParseResultsException
extends Exception {
    private IParsedElement _parsedElement;
    private List<IParseIssue> _parseIssues;
    private List<IParseIssue> _parseExceptions;
    private List<IParseIssue> _parseWarnings;
    private ICompilableType _ctxType;

    public ParseResultsException(IParsedElement parsedElement) {
        this._parsedElement = parsedElement;
    }

    public ParseResultsException(IParsedElement parsedElement, String message) {
        super(message);
        this._parsedElement = parsedElement;
    }

    public IParsedElement getParsedElement() {
        return this._parsedElement;
    }

    public List<IParseIssue> getParseIssues() {
        if (this._parseIssues == null) {
            this._parseIssues = this._parsedElement.getParseIssues();
        }
        return this._parseIssues;
    }

    public boolean hasParseExceptions() {
        return this.getParseExceptions().size() > 0;
    }

    public List<IParseIssue> getParseExceptions() {
        if (this._parseExceptions == null) {
            this._parseExceptions = this._parsedElement.getParseExceptions();
        }
        return this._parseExceptions;
    }

    public boolean hasOnlyParseWarnings() {
        return this.getParseExceptions().size() == 0;
    }

    public boolean hasParseWarnings() {
        return this.getParseWarnings().size() > 0;
    }

    public List<IParseIssue> getParseWarnings() {
        if (this._parseWarnings == null) {
            this._parseWarnings = this._parsedElement.getParseWarnings();
        }
        return this._parseWarnings;
    }

    public String getFeedback() {
        return ParseResultsException.getFeedback(this._ctxType, this.getParseExceptions(), this.getParseWarnings());
    }

    public static String getFeedback(List<IParseIssue> parseExceptions, List<IParseIssue> parseWarnings) {
        return ParseResultsException.getFeedback(null, parseExceptions, parseWarnings);
    }

    public static String getFeedback(ICompilableType type, List<IParseIssue> parseExceptions, List<IParseIssue> parseWarnings) {
        StringBuilder feedback = new StringBuilder();
        if (type != null) {
            if (type.getSourceFileHandle() != null && type.getSourceFileHandle().getFileName() != null) {
                feedback.append(type.getSourceFileHandle().getFileName()).append("\n\n");
            } else {
                feedback.append(type.getName()).append("\n\n");
            }
        }
        if (!parseExceptions.isEmpty()) {
            feedback.append("Errors: \n\n");
            for (IParseIssue pe : parseExceptions) {
                String strTypesExpected;
                feedback.append(pe.getConsoleMessage());
                IType typeExpected = pe.getExpectedType();
                if (typeExpected != null && (strTypesExpected = ParseResultsException.getExpectedTypeName(typeExpected)).length() > 0) {
                    feedback.append(" \nExpected Type: ");
                    feedback.append(strTypesExpected);
                }
                feedback.append("\nLine Number: ");
                feedback.append(pe.getLine());
                feedback.append("  Column: ");
                feedback.append(pe.getColumn());
                feedback.append("\n\n");
            }
        }
        if (!parseWarnings.isEmpty()) {
            if (feedback.length() > 0) {
                feedback.append("\n\n");
            }
            feedback.append("Warnings: \n\n");
            for (IParseIssue pw : parseWarnings) {
                feedback.append(pw.getConsoleMessage());
                feedback.append("\nLine Number: ");
                feedback.append(pw.getLine());
                feedback.append("  Column: ");
                feedback.append(pw.getColumn());
                feedback.append("\n\n");
            }
        }
        return feedback.toString();
    }

    public ITypeLoader getLoader() {
        if (this._parsedElement instanceof IClassStatement) {
            return ((IClassStatement)this._parsedElement).getGosuClass().getTypeLoader();
        }
        throw new UnsupportedOperationException();
    }

    public static String getExpectedTypeName(IType type) {
        if (type == null) {
            return "";
        }
        return ParseResultsException.getDisplayName(type);
    }

    private static String getDisplayName(IType typeExpected) {
        if (typeExpected instanceof IFunctionType) {
            return typeExpected.toString();
        }
        return typeExpected.getRelativeName();
    }

    public List<IParseIssue> getIssuesFromPos(int iPos) {
        List<IParseIssue> pes = this.getParseIssues();
        ArrayList<IParseIssue> matches = new ArrayList<IParseIssue>();
        for (int i = pes.size() - 1; i >= 0; --i) {
            IParseIssue e = pes.get(i);
            if (!e.appliesToPosition(iPos)) continue;
            matches.add(e);
        }
        return matches;
    }

    public void reset(IParsedElement pe) {
        this._parsedElement = pe;
        this._parseExceptions = null;
        this._parseIssues = null;
        this._parseWarnings = null;
    }

    @Override
    public String getMessage() {
        return this.getFeedback();
    }

    public List<IParseIssue> getParseExceptionsForKey(ResourceKey key) {
        return this.findMatchesForKey(key, this.getParseExceptions());
    }

    public List<IParseIssue> getParseWarningsForKey(ResourceKey key) {
        return this.findMatchesForKey(key, this.getParseWarnings());
    }

    private <T extends IParseIssue> List<T> findMatchesForKey(ResourceKey key, List<T> parseExceptions) {
        ArrayList<IParseIssue> results = new ArrayList<IParseIssue>();
        for (IParseIssue parseException : parseExceptions) {
            if (!parseException.getMessageKey().equals(key)) continue;
            results.add(parseException);
        }
        return results;
    }

    public void setContextType(ICompilableType contextType) {
        this._ctxType = contextType;
    }
}

