/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.gosuc.cli;

import gw.internal.ext.com.beust.jcommander.Parameter;
import gw.internal.ext.com.beust.jcommander.validators.PositiveInteger;
import java.util.ArrayList;
import java.util.List;

public class CommandLineOptions {
    @Parameter(names={"-ca", "-checkedArithmetic"}, description="Compile with checked arithmetic")
    private boolean _checkedarithmetic;
    @Parameter(names={"-cp", "-classpath"}, description="Specify where to find user class files")
    private String _classpath;
    @Parameter(names={"-d"}, description="Specify where to place generated class files")
    private String _destDir;
    @Parameter(names={"-help"}, description="Print a synopsis of standard options", help=true)
    private boolean _help;
    @Parameter(names={"-nowarn"}, description="Generate no warnings")
    private boolean _nowarn;
    @Parameter(names={"-sourcepath"}, description="Specify where to find input source files")
    private String _sourcepath;
    @Parameter(names={"-verbose"}, description="Output messages about what the compiler is doing")
    private boolean _verbose;
    @Parameter(names={"-version"}, description="Version information")
    private boolean _version;
    @Parameter(description="<source files>")
    private List<String> _srcFiles = new ArrayList<String>();
    @Parameter(names={"-maxerrs"}, description="Set the maximum number of errors to print", validateWith={PositiveInteger.class})
    private int _maxerrs = 100;
    @Parameter(names={"-maxwarns"}, description="Set the maximum number of warnings to print", validateWith={PositiveInteger.class})
    private int _maxwarns = Integer.MAX_VALUE;

    public boolean isCheckedArithmetic() {
        return this._checkedarithmetic;
    }

    public String getClasspath() {
        return this._classpath == null ? "" : this._classpath;
    }

    public String getDestDir() {
        return this._destDir == null ? "" : this._destDir;
    }

    public boolean isHelp() {
        return this._help;
    }

    public boolean isNoWarn() {
        return this._nowarn;
    }

    public String getSourcepath() {
        return this._sourcepath == null ? "" : this._sourcepath;
    }

    public boolean isVerbose() {
        return this._verbose;
    }

    public boolean isVersion() {
        return this._version;
    }

    public List<String> getSourceFiles() {
        return this._srcFiles;
    }

    public void setSourceFiles(List<String> srcFiles) {
        this._srcFiles = srcFiles;
    }

    public int getMaxErrs() {
        return this._maxerrs;
    }

    public int getMaxWarns() {
        return this._maxwarns;
    }
}

