/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.init;

import gw.fs.IFile;
import gw.lang.init.GosuRuntimeManifoldHost;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.ISourceFileHandle;
import gw.lang.reflect.java.IJavaType;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import manifold.api.host.IModule;
import manifold.api.host.IRuntimeManifoldHost;
import manifold.api.host.RefreshKind;
import manifold.api.type.ClassType;
import manifold.api.type.ContributorKind;
import manifold.api.type.ISourceKind;
import manifold.api.type.ITypeManifold;
import manifold.api.type.TypeName;

public class JavaTypeManifold
implements ITypeManifold {
    private IModule _module;

    public boolean accept(IModule module) {
        return module.getHost() instanceof IRuntimeManifoldHost;
    }

    public void init(IModule module) {
        this._module = module;
    }

    public IModule getModule() {
        return this._module;
    }

    public ISourceKind getSourceKind() {
        return ISourceKind.Java;
    }

    public ContributorKind getContributorKind() {
        return ContributorKind.Primary;
    }

    public boolean isType(String fqn) {
        return this.findJavaClass(fqn) != null;
    }

    public boolean isTopLevelType(String fqn) {
        if (!this.isType(fqn)) {
            return false;
        }
        IType type = this.findJavaClass(fqn);
        return type != null && type.getEnclosingType() == null;
    }

    public boolean isPackage(String pkg) {
        return TypeSystem.getNamespace(pkg) != null;
    }

    public ClassType getClassType(String fqn) {
        IType type = this.findJavaClass(fqn);
        return type == null ? null : ClassType.JavaClass;
    }

    public String getPackage(String fqn) {
        IType type = this.findJavaClass(fqn);
        return type == null ? null : type.getNamespace();
    }

    public String contribute(JavaFileManager.Location location, String fqn, String existing, DiagnosticListener<JavaFileObject> errorHandler) {
        IJavaType javaClass = (IJavaType)this.findJavaClass(fqn);
        return javaClass.getSourceFileHandle().getSource().getSource();
    }

    public Collection<String> getAllTypeNames() {
        return Collections.emptyList();
    }

    public Collection<TypeName> getTypeNames(String pkg) {
        return TypeSystem.getDefaultTypeLoader().getTypeNames(pkg);
    }

    public List<manifold.api.fs.IFile> findFilesForType(String fqn) {
        URL url;
        IJavaType javaClass = (IJavaType)this.findJavaClass(fqn);
        if (javaClass == null) {
            return Collections.emptyList();
        }
        ISourceFileHandle sfh = javaClass.getSourceFileHandle();
        if (sfh == null) {
            return Collections.emptyList();
        }
        IFile file = sfh.getFile();
        if (file == null) {
            return Collections.emptyList();
        }
        try {
            url = file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        return Collections.singletonList(GosuRuntimeManifoldHost.get().getFileSystem().getIFile(url));
    }

    public void clear() {
    }

    public boolean handlesFileExtension(String s) {
        return false;
    }

    public boolean handlesFile(manifold.api.fs.IFile file) {
        return "java".equalsIgnoreCase(file.getExtension());
    }

    public String[] getTypesForFile(manifold.api.fs.IFile iFile) {
        return new String[0];
    }

    public RefreshKind refreshedFile(manifold.api.fs.IFile iFile, String[] strings, RefreshKind refreshKind) {
        return null;
    }

    private IType findJavaClass(String fqn) {
        ISourceFileHandle sfh;
        IType type = TypeSystem.getByFullNameIfValid(fqn);
        if (type instanceof IJavaType && (sfh = ((IJavaType)type).getSourceFileHandle()) != null && sfh.getFile() != null && sfh.getFile().isJavaFile() && sfh.getFile().getExtension().equals("java")) {
            return type;
        }
        return null;
    }
}

