/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.reflect;

import gw.lang.UnstableAPI;
import gw.lang.parser.IExpression;
import gw.lang.reflect.ExceptionInfoBuilder;
import gw.lang.reflect.IAnnotationInfo;
import gw.lang.reflect.IExceptionInfo;
import gw.lang.reflect.IFeatureInfo;
import gw.lang.reflect.ILocationInfo;
import gw.lang.reflect.IMethodCallHandler;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.IOptionalParamCapable;
import gw.lang.reflect.IParameterInfo;
import gw.lang.reflect.IScriptabilityModifier;
import gw.lang.reflect.IType;
import gw.lang.reflect.ParameterInfoBuilder;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.java.JavaTypes;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@UnstableAPI
public class MethodInfoBuilder {
    private static final IMethodCallHandler EMPTY_CALL_HANDLER = new IMethodCallHandler(){

        @Override
        public Object handleCall(Object ctx, Object ... args) {
            return null;
        }
    };
    private String _name;
    private ParameterInfoBuilder[] _parameters = new ParameterInfoBuilder[0];
    private IType _returnType;
    private IMethodCallHandler _callHandler;
    private ExceptionInfoBuilder[] _exceptions = new ExceptionInfoBuilder[0];
    private String _deprecated;
    private boolean _isStatic;
    private String _description;
    private String _returnDescription;
    private boolean _hidden;
    private ILocationInfo _locationInfo;

    public MethodInfoBuilder withName(String name) {
        this._name = name;
        return this;
    }

    public MethodInfoBuilder withParameters(ParameterInfoBuilder ... parameters) {
        this._parameters = parameters == null ? new ParameterInfoBuilder[]{} : parameters;
        return this;
    }

    public MethodInfoBuilder withReturnType(IType returnType) {
        this._returnType = returnType;
        return this;
    }

    public MethodInfoBuilder withReturnType(Class returnType) {
        return this.withReturnType(TypeSystem.get(returnType));
    }

    public MethodInfoBuilder withCallHandler(IMethodCallHandler callHandler) {
        this._callHandler = callHandler;
        return this;
    }

    public MethodInfoBuilder withExceptions(ExceptionInfoBuilder ... exceptions) {
        this._exceptions = exceptions == null ? new ExceptionInfoBuilder[]{} : exceptions;
        return this;
    }

    public MethodInfoBuilder withDeprecated(String deprecated) {
        this._deprecated = deprecated;
        return this;
    }

    public MethodInfoBuilder withStatic() {
        return this.withStatic(true);
    }

    public MethodInfoBuilder withStatic(boolean isStatic) {
        this._isStatic = isStatic;
        return this;
    }

    public MethodInfoBuilder withDescription(String description) {
        this._description = description;
        return this;
    }

    public MethodInfoBuilder withReturnDescription(String returnDescription) {
        this._returnDescription = returnDescription;
        return this;
    }

    public MethodInfoBuilder withHidden() {
        return this.withHidden(true);
    }

    public MethodInfoBuilder withHidden(boolean hidden) {
        this._hidden = hidden;
        return this;
    }

    public MethodInfoBuilder like(Class clazz, String method, Class ... params) {
        IType[] types = new IType[params.length];
        for (int i = 0; i < params.length; ++i) {
            types[i] = TypeSystem.get(params[i]);
        }
        return this.like(TypeSystem.get(clazz), method, types);
    }

    public MethodInfoBuilder like(IType type, String method, IType ... params) {
        return this.like(type.getTypeInfo().getMethod(method, params));
    }

    public MethodInfoBuilder like(IMethodInfo method) {
        this.withName(method.getDisplayName());
        this.withReturnType(method.getReturnType());
        this.withCallHandler(method.getCallHandler());
        this.withStatic(method.isStatic());
        this.withDeprecated(method.getDeprecatedReason());
        this.withDescription(method.getDescription());
        this.withReturnDescription(method.getReturnDescription());
        IParameterInfo[] delegateParams = method.getParameters();
        ParameterInfoBuilder[] params = new ParameterInfoBuilder[delegateParams.length];
        for (int i = 0; i < params.length; ++i) {
            params[i] = new ParameterInfoBuilder().like(delegateParams[i]);
        }
        this.withParameters(params);
        List<IExceptionInfo> delegateExceptions = method.getExceptions();
        ExceptionInfoBuilder[] exceptions = new ExceptionInfoBuilder[delegateExceptions.size()];
        int idx = 0;
        for (IExceptionInfo info : delegateExceptions) {
            exceptions[idx++] = new ExceptionInfoBuilder().like(info);
        }
        this.withExceptions(exceptions);
        this._locationInfo = method.getLocationInfo();
        return this;
    }

    public IMethodInfo build(IFeatureInfo container) {
        return new BuiltMethodInfo(this, container);
    }

    public MethodInfoBuilder withLocation(ILocationInfo locationInfo) {
        this._locationInfo = locationInfo;
        return this;
    }

    private static class BuiltMethodInfo
    implements IMethodInfo,
    IOptionalParamCapable {
        private final IFeatureInfo _container;
        private final String _name;
        private final String _signature;
        private final IParameterInfo[] _parameters;
        private final IType _returnType;
        private final IMethodCallHandler _callHandler;
        private final List<IExceptionInfo> _exceptions;
        private final String _deprecated;
        private final boolean _isStatic;
        private final String _description;
        private final String _returnDescription;
        private final boolean _hidden;
        private final ILocationInfo _locationInfo;

        public BuiltMethodInfo(MethodInfoBuilder builder, IFeatureInfo container) {
            assert (container != null);
            assert (builder._name != null);
            this._container = container;
            this._name = builder._name;
            this._parameters = new IParameterInfo[builder._parameters.length];
            for (int i = 0; i < builder._parameters.length; ++i) {
                this._parameters[i] = builder._parameters[i].build(this._container);
            }
            this._returnType = builder._returnType == null ? JavaTypes.pVOID() : builder._returnType;
            this._callHandler = builder._callHandler == null ? EMPTY_CALL_HANDLER : builder._callHandler;
            IExceptionInfo[] tmp = new IExceptionInfo[builder._exceptions.length];
            for (int i = 0; i < builder._exceptions.length; ++i) {
                tmp[i] = builder._exceptions[i].build(this._container);
            }
            this._exceptions = Collections.unmodifiableList(Arrays.asList(tmp));
            this._deprecated = builder._deprecated;
            this._isStatic = builder._isStatic;
            this._description = builder._description;
            this._returnDescription = builder._returnDescription;
            this._hidden = builder._hidden;
            this._signature = this.makeSignature();
            this._locationInfo = builder._locationInfo == null ? ILocationInfo.EMPTY : builder._locationInfo;
        }

        @Override
        public IParameterInfo[] getParameters() {
            return this._parameters;
        }

        @Override
        public IExpression[] getDefaultValueExpressions() {
            IExpression[] defValues = new IExpression[this._parameters.length];
            for (int i = 0; i < this._parameters.length; ++i) {
                defValues[i] = ((ParameterInfoBuilder.BuiltParameterInfo)this._parameters[i]).getDefaultValue();
            }
            return defValues;
        }

        @Override
        public String[] getParameterNames() {
            String[] names = new String[this._parameters.length];
            for (int i = 0; i < this._parameters.length; ++i) {
                names[i] = ((ParameterInfoBuilder.BuiltParameterInfo)this._parameters[i]).getName();
            }
            return names;
        }

        @Override
        public IType getReturnType() {
            return this._returnType;
        }

        @Override
        public IMethodCallHandler getCallHandler() {
            return this._callHandler;
        }

        @Override
        public String getReturnDescription() {
            return this._returnDescription;
        }

        @Override
        public List<IExceptionInfo> getExceptions() {
            return this._exceptions;
        }

        @Override
        public boolean isScriptable() {
            return !this._hidden;
        }

        @Override
        public boolean isDeprecated() {
            return this._deprecated != null;
        }

        @Override
        public String getDeprecatedReason() {
            return this._deprecated;
        }

        @Override
        public boolean isDefaultImpl() {
            return false;
        }

        @Override
        public boolean isVisible(IScriptabilityModifier constraint) {
            return true;
        }

        @Override
        public boolean isHidden() {
            return this._hidden;
        }

        @Override
        public boolean isStatic() {
            return this._isStatic;
        }

        @Override
        public boolean isPrivate() {
            return false;
        }

        @Override
        public boolean isInternal() {
            return false;
        }

        @Override
        public boolean isProtected() {
            return false;
        }

        @Override
        public boolean isPublic() {
            return true;
        }

        @Override
        public boolean isAbstract() {
            return false;
        }

        @Override
        public boolean isFinal() {
            return false;
        }

        @Override
        public boolean isReified() {
            return false;
        }

        @Override
        public List<IAnnotationInfo> getAnnotations() {
            return Collections.emptyList();
        }

        @Override
        public List<IAnnotationInfo> getDeclaredAnnotations() {
            return Collections.emptyList();
        }

        @Override
        public List<IAnnotationInfo> getAnnotationsOfType(IType type) {
            return Collections.emptyList();
        }

        @Override
        public IAnnotationInfo getAnnotation(IType type) {
            return null;
        }

        @Override
        public boolean hasDeclaredAnnotation(IType type) {
            return false;
        }

        @Override
        public boolean hasAnnotation(IType type) {
            return false;
        }

        @Override
        public IFeatureInfo getContainer() {
            return this._container;
        }

        @Override
        public IType getOwnersType() {
            return this._container.getOwnersType();
        }

        @Override
        public String getName() {
            return this._signature;
        }

        private String makeSignature() {
            Object name = this.getDisplayName();
            name = (String)name + "(";
            IParameterInfo[] parameterInfos = this.getParameters();
            if (parameterInfos.length > 0) {
                name = (String)name + " ";
                for (int i = 0; i < parameterInfos.length; ++i) {
                    IParameterInfo iParameterInfo = this.getParameters()[i];
                    if (i != 0) {
                        name = (String)name + ", ";
                    }
                    name = (String)name + iParameterInfo.getFeatureType().getName();
                }
                name = (String)name + " ";
            }
            name = (String)name + ")";
            return name;
        }

        @Override
        public String getDisplayName() {
            return this._name;
        }

        @Override
        public String getDescription() {
            return this._description;
        }

        @Override
        public ILocationInfo getLocationInfo() {
            return this._locationInfo;
        }

        public String toString() {
            return this.getName();
        }
    }
}

