/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.javac;

import gw.lang.IIssue;
import gw.lang.IIssueContainer;
import gw.lang.javac.JavaIssue;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaFileObject;

public class JavaIssueContainer
implements IIssueContainer {
    private DiagnosticCollector<JavaFileObject> _errorHandler;
    private List<IIssue> _issues;

    public JavaIssueContainer(DiagnosticCollector<JavaFileObject> errorHandler) {
        this._errorHandler = errorHandler;
    }

    @Override
    public List<IIssue> getIssues() {
        if (this._issues == null) {
            ArrayList<IIssue> issues = new ArrayList<IIssue>();
            if (this._errorHandler != null) {
                for (Diagnostic<JavaFileObject> diagnostic : this._errorHandler.getDiagnostics()) {
                    JavaIssue issue = new JavaIssue(diagnostic);
                    issues.add(issue);
                }
            }
            this._issues = issues;
        }
        return this._issues;
    }

    @Override
    public List<IIssue> getWarnings() {
        return this.getIssues().stream().filter(issue -> issue.getKind() == IIssue.Kind.Warning).collect(Collectors.toList());
    }

    @Override
    public List<IIssue> getErrors() {
        return this.getIssues().stream().filter(issue -> issue.getKind() == IIssue.Kind.Error).collect(Collectors.toList());
    }

    @Override
    public boolean isEmpty() {
        return this.getIssues().isEmpty();
    }
}

