/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.reflect;

import gw.lang.reflect.IAttributedFeatureInfo;
import java.util.StringJoiner;

public class Modifier {
    public static final int PUBLIC = 1;
    public static final int PRIVATE = 2;
    public static final int PROTECTED = 4;
    public static final int STATIC = 8;
    public static final int FINAL = 16;
    public static final int SYNCHRONIZED = 32;
    public static final int VOLATILE = 64;
    public static final int TRANSIENT = 128;
    public static final int NATIVE = 256;
    public static final int INTERFACE = 512;
    public static final int ABSTRACT = 1024;
    public static final int STRICT = 2048;
    public static final int BRIDGE = 64;
    public static final int VARARGS = 128;
    public static final int SYNTHETIC = 4096;
    public static final int ANNOTATION = 8192;
    public static final int ENUM = 16384;
    public static final int MANDATED = 32768;
    private static final int CLASS_MODIFIERS = 3103;
    private static final int INTERFACE_MODIFIERS = 3087;
    private static final int CONSTRUCTOR_MODIFIERS = 7;
    private static final int METHOD_MODIFIERS = 3391;
    private static final int FIELD_MODIFIERS = 223;
    private static final int PARAMETER_MODIFIERS = 16;
    static final int ACCESS_MODIFIERS = 7;
    public static final int OVERRIDE = 65536;
    public static final int HIDE = 0x2000000;
    public static final int CLASS_MEMBER = 262144;
    public static final int INTERNAL = 524288;
    public static final int REIFIED = 0x100000;
    public static final int DEPRECATED = 131072;

    public static boolean isPublic(int mod) {
        return (mod & 1) != 0;
    }

    public static boolean isPrivate(int mod) {
        return (mod & 2) != 0;
    }

    public static boolean isProtected(int mod) {
        return (mod & 4) != 0;
    }

    public static boolean isStatic(int mod) {
        return (mod & 8) != 0;
    }

    public static boolean isFinal(int mod) {
        return (mod & 0x10) != 0;
    }

    public static boolean isSynchronized(int mod) {
        return (mod & 0x20) != 0;
    }

    public static boolean isVolatile(int mod) {
        return (mod & 0x40) != 0;
    }

    public static boolean isTransient(int mod) {
        return (mod & 0x80) != 0;
    }

    public static boolean isNative(int mod) {
        return (mod & 0x100) != 0;
    }

    public static boolean isInterface(int mod) {
        return (mod & 0x200) != 0;
    }

    public static boolean isAbstract(int mod) {
        return (mod & 0x400) != 0;
    }

    public static boolean isStrict(int mod) {
        return (mod & 0x800) != 0;
    }

    public static String toString(int mod) {
        StringJoiner sj = new StringJoiner(" ");
        if ((mod & 1) != 0) {
            sj.add("public");
        }
        if ((mod & 4) != 0) {
            sj.add("protected");
        }
        if ((mod & 2) != 0) {
            sj.add("private");
        }
        if ((mod & 0x400) != 0) {
            sj.add("abstract");
        }
        if ((mod & 8) != 0) {
            sj.add("static");
        }
        if ((mod & 0x10) != 0) {
            sj.add("final");
        }
        if ((mod & 0x80) != 0) {
            sj.add("transient");
        }
        if ((mod & 0x40) != 0) {
            sj.add("volatile");
        }
        if ((mod & 0x20) != 0) {
            sj.add("synchronized");
        }
        if ((mod & 0x100) != 0) {
            sj.add("native");
        }
        if ((mod & 0x800) != 0) {
            sj.add("strictfp");
        }
        if ((mod & 0x200) != 0) {
            sj.add("interface");
        }
        return sj.toString();
    }

    public static boolean isSynthetic(int mod) {
        return (mod & 0x1000) != 0;
    }

    public static boolean isMandated(int mod) {
        return (mod & 0x8000) != 0;
    }

    public static int classModifiers() {
        return 3103;
    }

    public static int interfaceModifiers() {
        return 3087;
    }

    public static int constructorModifiers() {
        return 7;
    }

    public static int methodModifiers() {
        return 3391;
    }

    public static int fieldModifiers() {
        return 223;
    }

    public static int parameterModifiers() {
        return 16;
    }

    public static int getModifiersFrom(IAttributedFeatureInfo afi) {
        int iModifiers = 0;
        iModifiers = Modifier.setBit(iModifiers, afi.isPublic(), 1);
        iModifiers = Modifier.setBit(iModifiers, afi.isPrivate(), 2);
        iModifiers = Modifier.setBit(iModifiers, afi.isProtected(), 4);
        iModifiers = Modifier.setBit(iModifiers, afi.isInternal(), 524288);
        iModifiers = Modifier.setBit(iModifiers, afi.isStatic(), 8);
        iModifiers = Modifier.setBit(iModifiers, afi.isFinal(), 16);
        iModifiers = Modifier.setBit(iModifiers, afi.isReified(), 0x100000);
        return iModifiers;
    }

    public static boolean isHide(int mod) {
        return (mod & 0x2000000) != 0;
    }

    public static boolean isOverride(int mod) {
        return (mod & 0x10000) != 0;
    }

    public static boolean isClassMember(int mod) {
        return (mod & 0x40000) != 0;
    }

    public static boolean isInternal(int mod) {
        return (mod & 0x80000) != 0;
    }

    public static boolean isEnum(int mod) {
        return (mod & 0x4000) != 0;
    }

    public static boolean isDeprecated(int mod) {
        return (mod & 0x20000) != 0;
    }

    public static boolean isAnnotation(int mod) {
        return (mod & 0x2000) != 0;
    }

    public static boolean isReified(int mod) {
        return (mod & 0x100000) != 0;
    }

    public static int setPublic(int mod, boolean bValue) {
        return Modifier.setBit(mod, bValue, 1);
    }

    public static int setPrivate(int mod, boolean bValue) {
        return Modifier.setBit(mod, bValue, 2);
    }

    public static int setProtected(int mod, boolean bValue) {
        return Modifier.setBit(mod, bValue, 4);
    }

    public static int setStatic(int mod, boolean bValue) {
        return Modifier.setBit(mod, bValue, 8);
    }

    public static int setAbstract(int mod, boolean bValue) {
        return Modifier.setBit(mod, bValue, 1024);
    }

    public static int setFinal(int mod, boolean bValue) {
        return Modifier.setBit(mod, bValue, 16);
    }

    public static int setOverride(int mod, boolean bValue) {
        return Modifier.setBit(mod, bValue, 65536);
    }

    public static int setHide(int mod, boolean bValue) {
        return Modifier.setBit(mod, bValue, 0x2000000);
    }

    public static int setClassMember(int mod, boolean bValue) {
        return Modifier.setBit(mod, bValue, 262144);
    }

    public static int setTransient(int mod, boolean bValue) {
        return Modifier.setBit(mod, bValue, 128);
    }

    public static int setInternal(int mod, boolean bValue) {
        return Modifier.setBit(mod, bValue, 524288);
    }

    public static int setEnum(int mod, boolean bValue) {
        return Modifier.setBit(mod, bValue, 16384);
    }

    public static int setDeprecated(int mod, boolean bValue) {
        return Modifier.setBit(mod, bValue, 131072);
    }

    public static int setReified(int mod, boolean bValue) {
        return Modifier.setBit(mod, bValue, 0x100000);
    }

    private static int setBit(int mod, boolean bValue, int bit) {
        if (bValue) {
            return mod |= bit;
        }
        return mod &= ~bit;
    }

    public static String toModifierString(int mod) {
        int len;
        StringBuffer sb = new StringBuffer();
        if ((mod & 1) != 0) {
            sb.append("public ");
        }
        if ((mod & 4) != 0) {
            sb.append("protected ");
        }
        if ((mod & 0x80000) != 0) {
            sb.append("internal ");
        }
        if ((mod & 2) != 0) {
            sb.append("private ");
        }
        if ((mod & 0x400) != 0) {
            sb.append("abstract ");
        }
        if ((mod & 8) != 0) {
            sb.append("static ");
        }
        if ((mod & 0x10) != 0) {
            sb.append("final ");
        }
        if ((mod & 0x80) != 0) {
            sb.append("transient ");
        }
        if ((mod & 0x40) != 0) {
            sb.append("volatile ");
        }
        if ((mod & 0x20) != 0) {
            sb.append("synchronized ");
        }
        if ((mod & 0x100) != 0) {
            sb.append("native ");
        }
        if ((mod & 0x800) != 0) {
            sb.append("strictfp ");
        }
        if ((mod & 0x100000) != 0) {
            sb.append("reified ");
        }
        if ((len = sb.length()) > 0) {
            return sb.toString().substring(0, len - 1);
        }
        return "";
    }
}

