/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.reflect;

import gw.lang.reflect.IConstructorInfo;
import gw.lang.reflect.IFeatureInfo;
import gw.lang.reflect.IFunctionType;
import gw.lang.reflect.IGenericMethodInfo;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.IParameterInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.MethodList;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.IGenericTypeVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.Set;

public class TypeInfoUtil {
    public static <S extends CharSequence, T extends IFeatureInfo> List<T> makeSortedUnmodifiableRandomAccessListFromFeatures(Map<S, T> map) {
        if (map.isEmpty()) {
            return Collections.emptyList();
        }
        Collection<T> values = map.values();
        return TypeInfoUtil.makeSortedUnmodifiableRandomAccessList(values);
    }

    public static <T extends IFeatureInfo> List<T> makeSortedUnmodifiableRandomAccessList(Collection<T> collection) {
        if (collection.isEmpty()) {
            return Collections.emptyList();
        }
        List<Object> list = collection instanceof List && collection instanceof RandomAccess ? (List)collection : new ArrayList<T>(collection);
        TypeInfoUtil.sortByName(list);
        return Collections.unmodifiableList(list);
    }

    public static MethodList makeSortedUnmodifiableRandomAccessList(MethodList collection) {
        if (collection.isEmpty()) {
            return MethodList.EMPTY;
        }
        ArrayList<IMethodInfo> list = new ArrayList<IMethodInfo>(collection);
        TypeInfoUtil.sortByName(list);
        return new MethodList((List<IMethodInfo>)list);
    }

    public static <T extends IFeatureInfo> void sortByName(List<T> featureInfos) {
        if (featureInfos.isEmpty()) {
            return;
        }
        Collections.sort(featureInfos, new Comparator<IFeatureInfo>(){

            @Override
            public int compare(IFeatureInfo o1, IFeatureInfo o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
    }

    public static String getMethodSignature(IMethodInfo mi) {
        IFunctionType type = TypeSystem.getOrCreateFunctionType(mi);
        return mi.getDisplayName() + TypeInfoUtil.getParameterDisplay(mi) + " : " + TypeInfoUtil.getTypeName(type.getReturnType());
    }

    public static String getConstructorSignature(IConstructorInfo constructorInfo) {
        return constructorInfo.getDisplayName() + TypeInfoUtil.getParameterDisplay(constructorInfo);
    }

    public static String getParameterDisplay(IMethodInfo mi) {
        IParameterInfo[] pd = mi.getParameters();
        return TypeInfoUtil.getParameterDisplay(pd);
    }

    public static String getParameterDisplay(IConstructorInfo ci) {
        IParameterInfo[] pd = ci.getParameters();
        return TypeInfoUtil.getParameterDisplay(pd);
    }

    private static String getParameterDisplay(IParameterInfo[] pds) {
        if (pds == null || pds.length == 0) {
            return "()";
        }
        Object strParams = "(";
        for (int i = 0; i < pds.length; ++i) {
            strParams = (String)strParams + (i == 0 ? "" : ", ") + pds[i].getFeatureType().getName();
        }
        strParams = (String)strParams + ")";
        return strParams;
    }

    public static String getTypeVarList(IFeatureInfo fi) {
        return TypeInfoUtil.getTypeVarList(fi, false);
    }

    public static String getTypeVarList(IFeatureInfo fi, boolean bRelative) {
        if (fi instanceof IGenericMethodInfo) {
            StringBuilder vars = new StringBuilder();
            int i = 0;
            for (IGenericTypeVariable tv : ((IGenericMethodInfo)((Object)fi)).getTypeVariables()) {
                vars.append(i++ > 0 ? (char)',' : '<');
                vars.append(tv.getNameWithBounds(bRelative));
            }
            if (i > 0) {
                return vars.append('>').toString();
            }
        }
        return "";
    }

    public static String getTypeVarListNoBounds(IFeatureInfo fi) {
        if (fi instanceof IGenericMethodInfo) {
            StringBuilder vars = new StringBuilder();
            int i = 0;
            for (IGenericTypeVariable tv : ((IGenericMethodInfo)((Object)fi)).getTypeVariables()) {
                vars.append(i++ > 0 ? (char)',' : '<');
                vars.append(tv.getName());
            }
            if (i > 0) {
                return vars.append('>').toString();
            }
        }
        return "";
    }

    public static String getTypeName(IType type) {
        Object strType = type.isArray() ? TypeInfoUtil.getTypeName(type.getComponentType()) + "[]" : type.getRelativeName();
        return strType;
    }

    public static String normalizePackageName(String packageName) {
        String[] parts;
        StringBuilder sb = new StringBuilder();
        for (String part : parts = packageName.split("\\.")) {
            if (sb.length() > 0) {
                sb.append('.');
            }
            sb.append(TypeInfoUtil.normalizeGosuIdentifier(part));
        }
        return sb.toString();
    }

    public static String normalizeGosuIdentifier(String propertyName, Set<String> usedPropertyNames, boolean caseSensitive) {
        propertyName = TypeInfoUtil.normalizeGosuIdentifier(propertyName);
        int suffix = 2;
        Object newPropertyName = propertyName;
        while (!usedPropertyNames.add((String)(caseSensitive ? newPropertyName : ((String)newPropertyName).toLowerCase()))) {
            newPropertyName = propertyName + suffix++;
        }
        return newPropertyName;
    }

    public static String normalizeGosuIdentifier(String name) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (i == 0) {
                if (Character.isJavaIdentifierStart(ch) || Character.isDigit(ch)) {
                    sb.append(ch);
                    continue;
                }
                if (Character.isJavaIdentifierPart(ch)) {
                    sb.append('_');
                    sb.append(ch);
                    continue;
                }
                sb.append('_');
                continue;
            }
            if (Character.isJavaIdentifierPart(ch)) {
                sb.append(ch);
                continue;
            }
            sb.append('_');
        }
        name = sb.toString();
        if (name.length() == 0) {
            name = "_";
        }
        return name;
    }
}

