/*
 * Decompiled with CFR 0.152.
 */
package gw.util.perf;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InvocationCounter {
    private Map<String, Count> map = new HashMap<String, Count>();
    private List<String> list = new ArrayList<String>();
    private boolean _storeList;

    public InvocationCounter(boolean storeList) {
        this._storeList = storeList;
    }

    public void recordInvocation(String description, int n) {
        description.replace("\n", "\\n");
        Count c = this.map.get(description);
        if (c == null) {
            c = new Count();
            c.description = description;
            this.map.put(description, c);
        }
        c.count += n;
        if (this._storeList) {
            this.list.add(description);
        }
    }

    public void recordInvocation(String description) {
        this.recordInvocation(description, 1);
    }

    public void print() {
        this.print(System.out);
    }

    public void print(PrintStream stream) {
        ArrayList<Count> counts = new ArrayList<Count>(this.map.values());
        Collections.sort(counts);
        int total = 0;
        for (Count c : counts) {
            total += c.count;
        }
        for (Count c : counts) {
            stream.println(c.toString(total));
        }
        stream.println("\n\n Total: " + total);
    }

    public void printList() {
        this.printList(System.out);
    }

    public void saveListTo(String fileName) {
        try {
            PrintStream stream = new PrintStream(new File(fileName));
            this.printList(stream);
            stream.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void printList(PrintStream stream) {
        for (String s : this.list) {
            stream.println(s);
        }
    }

    public void saveTo(String fileName) {
        int i = 1;
        Object uniqueFileName = fileName;
        while (new File((String)uniqueFileName).exists()) {
            int index = fileName.indexOf(46);
            uniqueFileName = index < 0 ? fileName + i : fileName.substring(0, index) + i + fileName.substring(index);
            ++i;
        }
        try {
            PrintStream stream = new PrintStream(new File((String)uniqueFileName));
            this.print(stream);
            stream.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void clear() {
        this.map.clear();
    }

    private static class Count
    implements Comparable<Count> {
        public String description;
        public int count;

        private Count() {
        }

        @Override
        public int compareTo(Count c) {
            return c.count - this.count;
        }

        public boolean equals(Object o) {
            if (o instanceof Count) {
                return this.description.equals(((Count)o).description);
            }
            return false;
        }

        public String toString() {
            StringBuilder s = new StringBuilder(256);
            s.append(this.count);
            int n = s.length();
            for (int i = 0; i < 15 - n; ++i) {
                s.append(' ');
            }
            s.append(this.description);
            return s.toString();
        }

        public String toString(int total) {
            StringBuilder s = new StringBuilder(256);
            s.append(this.count);
            s.append(" (");
            s.append(new DecimalFormat("##.#").format(100.0 * (double)this.count / (double)total));
            s.append("%)");
            int n = s.length();
            for (int i = 0; i < 20 - n; ++i) {
                s.append(' ');
            }
            s.append(this.description);
            return s.toString();
        }
    }
}

