/*
 * Decompiled with CFR 0.152.
 */
package gw.fs;

import gw.config.CommonServices;
import gw.fs.IDirectory;
import gw.fs.IFile;
import gw.fs.ResourcePath;
import gw.fs.jar.JarFileDirectoryImpl;
import gw.fs.physical.IPhysicalFileSystem;
import gw.fs.physical.PhysicalDirectoryImpl;
import gw.fs.physical.PhysicalFileImpl;
import gw.fs.physical.fast.FastPhysicalFileSystem;
import gw.lang.UnstableAPI;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;

@UnstableAPI
public class FileFactory {
    private static final FileFactory INSTANCE = new FileFactory();
    private IPhysicalFileSystem _defaultPhysicalFileSystem = this.createDefaultPhysicalFileSystem();

    private FileFactory() {
    }

    public static FileFactory instance() {
        return INSTANCE;
    }

    public IDirectory getIDirectory(File f) {
        if (f.getName().endsWith(".jar") && f.isFile()) {
            return new JarFileDirectoryImpl(f);
        }
        return new PhysicalDirectoryImpl(ResourcePath.parse(f.getAbsolutePath()), this._defaultPhysicalFileSystem);
    }

    public IFile getIFile(File f) {
        return new PhysicalFileImpl(ResourcePath.parse(f.getAbsolutePath()), this._defaultPhysicalFileSystem);
    }

    public IDirectory getIDirectory(String absolutePath) {
        if (absolutePath.endsWith(".jar") && new File(absolutePath).isFile()) {
            return new JarFileDirectoryImpl(new File(absolutePath));
        }
        return new PhysicalDirectoryImpl(ResourcePath.parse(absolutePath), this._defaultPhysicalFileSystem);
    }

    public IFile getIFile(String absolutePath) {
        return new PhysicalFileImpl(ResourcePath.parse(absolutePath), this._defaultPhysicalFileSystem);
    }

    public IFile getIFile(URL url) {
        try {
            return this.getIFile(url.toURI());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public IFile getIFile(URI uri) {
        return this.getIFile(uri, true);
    }

    public IFile getIFile(URL url, boolean bCreateIfNotExists) {
        try {
            return this.getIFile(url.toURI(), bCreateIfNotExists);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public IFile getIFile(URI uri, boolean bCreateIfNotExists) {
        if (uri.getScheme().equals("file")) {
            try {
                if (uri.getFragment() != null) {
                    uri = new URI(uri.getScheme(), uri.getSchemeSpecificPart(), null);
                }
                return this.getIFile(new File(uri));
            }
            catch (URISyntaxException ex) {
                throw new RuntimeException(ex);
            }
            catch (IllegalArgumentException ex) {
                throw new IllegalArgumentException("Unable to parse URI " + uri, ex);
            }
        }
        if (uri.getScheme().equals("jar")) {
            File jarFile;
            String path = uri.getPath();
            path = path == null ? uri.getSchemeSpecificPart() : path;
            int idx = path.lastIndexOf(33);
            String filePath = path.substring(idx + 1);
            String jarPath = path.substring(0, idx);
            try {
                jarFile = this.getIFile(new URL(jarPath)).toJavaFile();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
            JarFileDirectoryImpl jarFileDirectory = new JarFileDirectoryImpl(jarFile);
            if (bCreateIfNotExists) {
                return jarFileDirectory.getOrCreateFile(filePath);
            }
            return jarFileDirectory.file(filePath);
        }
        Path path = Paths.get(uri);
        return CommonServices.getFileSystem().getIFile(path);
    }

    public IPhysicalFileSystem getDefaultPhysicalFileSystem() {
        return this._defaultPhysicalFileSystem;
    }

    public IPhysicalFileSystem getRootPhysicalFileSystem() {
        return this._defaultPhysicalFileSystem;
    }

    public void setDefaultPhysicalFileSystem(IPhysicalFileSystem fileSystem) {
        this._defaultPhysicalFileSystem = fileSystem;
    }

    private IPhysicalFileSystem createDefaultPhysicalFileSystem() {
        return new FastPhysicalFileSystem();
    }
}

