/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.annotation;

import gw.lang.reflect.IConstructorInfo;
import gw.lang.reflect.IFeatureInfo;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.IParameterInfo;
import gw.lang.reflect.IPropertyInfo;
import gw.lang.reflect.ITypeInfo;
import java.lang.annotation.ElementType;

public enum UsageTarget {
    AllTarget,
    TypeTarget,
    ConstructorTarget,
    PropertyTarget,
    MethodTarget,
    ParameterTarget;


    public static UsageTarget convert(ElementType elementType) {
        switch (elementType) {
            case CONSTRUCTOR: {
                return ConstructorTarget;
            }
            case FIELD: {
                return PropertyTarget;
            }
            case TYPE: {
                return TypeTarget;
            }
            case METHOD: {
                return MethodTarget;
            }
            case PARAMETER: {
                return ParameterTarget;
            }
        }
        return AllTarget;
    }

    public static UsageTarget getForFeature(IFeatureInfo fi) {
        if (fi instanceof IConstructorInfo) {
            return ConstructorTarget;
        }
        if (fi instanceof IPropertyInfo) {
            return PropertyTarget;
        }
        if (fi instanceof IMethodInfo) {
            return MethodTarget;
        }
        if (fi instanceof IParameterInfo) {
            return ParameterTarget;
        }
        if (fi instanceof ITypeInfo) {
            return TypeTarget;
        }
        return AllTarget;
    }
}

