/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.gosuc;

import gw.config.CommonServices;
import gw.config.IMemoryMonitor;
import gw.fs.IDirectory;
import gw.fs.IFile;
import gw.lang.gosuc.GosucDependency;
import gw.lang.gosuc.GosucModule;
import gw.lang.gosuc.GosucProjectParser;
import gw.lang.gosuc.GosucSdk;
import gw.lang.gosuc.GosucUtil;
import gw.lang.gosuc.ICustomParser;
import gw.lang.parser.IToken;
import gw.lang.reflect.ITypeLoader;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.module.Dependency;
import gw.lang.reflect.module.IExecutionEnvironment;
import gw.lang.reflect.module.IJreModule;
import gw.lang.reflect.module.IModule;
import gw.lang.reflect.module.IProject;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class GosucProject
implements IProject {
    private String _name;
    private GosucSdk _sdk;
    private List<GosucModule> _modules;
    private List<String> _globalLoaders;

    public GosucProject(String name, GosucSdk sdk, List<GosucModule> modules, List<String> globalLoaders) {
        this._name = name;
        this._sdk = sdk;
        this._modules = modules;
        this._globalLoaders = globalLoaders;
    }

    public GosucProject() {
        this(TypeSystem.getExecutionEnvironment());
    }

    public GosucProject(IExecutionEnvironment execEnv) {
        this._name = this.makeLegalName(execEnv.getProject().getName());
        this.assignSdk(execEnv);
        this.assignModules(execEnv);
        this.assignGlobalLoadersFromProvider();
    }

    private String makeLegalName(CharSequence name) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '-' || c == '_') {
                sb.append(c);
                continue;
            }
            sb.append('_');
        }
        return sb.toString();
    }

    public void startDependencies() {
    }

    private void assignModules(IExecutionEnvironment execEnv) {
        List<? extends IModule> modules = execEnv.getModules();
        ArrayList<GosucModule> gosucModules = new ArrayList<GosucModule>();
        for (IModule iModule : modules) {
            if (iModule == execEnv.getGlobalModule() || iModule == execEnv.getJreModule()) continue;
            gosucModules.add(this.makeModule(iModule));
        }
        this._modules = gosucModules;
    }

    private GosucModule makeModule(IModule module) {
        IDirectory outputPath = module.getOutputPath();
        return new GosucModule(module.getName(), GosucUtil.makeStringPaths(module.getSourcePath()), GosucUtil.makeStringPaths(module.getJavaClassPath()), GosucUtil.makeStringPaths(module.getBackingSourcePath()), outputPath != null ? outputPath.getPath().getPathString() : null, this.makeDependencies(module.getDependencies()), GosucUtil.makeStringPaths(module.getExcludedPaths()));
    }

    private List<GosucDependency> makeDependencies(List<Dependency> dependencies) {
        ArrayList<GosucDependency> deps = new ArrayList<GosucDependency>();
        for (Dependency d : dependencies) {
            if (d.getModule().getName().equals("_jre_module_")) continue;
            deps.add(new GosucDependency(d.getModule().getName(), d.isExported()));
        }
        return deps;
    }

    private void assignSdk(IExecutionEnvironment execEnv) {
        List<String> classpath = GosucUtil.makeStringPaths(execEnv.getJreModule().getJavaClassPath());
        List<String> backingSource = GosucUtil.makeStringPaths(execEnv.getJreModule().getBackingSourcePath());
        this._sdk = new GosucSdk(classpath, backingSource);
    }

    private void assignGlobalLoadersFromProvider() {
        List<Class<? extends ITypeLoader>> loaderClasses = CommonServices.getGlobalLoaderProvider().getGlobalLoaderTypes();
        ArrayList<String> globalLoaders = new ArrayList<String>();
        for (Class<? extends ITypeLoader> cls : loaderClasses) {
            globalLoaders.add(cls.getName());
        }
        this._globalLoaders = globalLoaders;
    }

    @Override
    public String getName() {
        return this._name;
    }

    public GosucSdk getSdk() {
        return this._sdk;
    }

    public List<GosucModule> getModules() {
        return this._modules;
    }

    public List<String> getGlobalLoaders() {
        return this._globalLoaders;
    }

    public String write() {
        return this.getName() + " {\n" + GosucUtil.indent(this.getSdk().write()) + GosucUtil.indent(this.writeModules()) + GosucUtil.indent(this.writeGlobalLoaders()) + GosucUtil.indent(this.writeCustom()) + "\n}\n";
    }

    protected String writeCustom() {
        return "";
    }

    private String writeGlobalLoaders() {
        StringBuilder sb = new StringBuilder();
        sb.append("\nglobal-loaders {\n");
        for (String path : this.getGlobalLoaders()) {
            sb.append("  ").append("\"").append(path).append("\",\n");
        }
        sb.append("}\n");
        return sb.toString();
    }

    private String writeModules() {
        StringBuilder sb = new StringBuilder();
        sb.append("\nmodules {\n");
        for (GosucModule mod : this.getModules()) {
            sb.append(GosucUtil.indent(mod.write())).append("\n");
        }
        sb.append("}");
        return sb.toString();
    }

    public static GosucProject parse(GosucProjectParser parser, ICustomParser custParser) {
        IToken t = parser.getTokenizer().getCurrentToken();
        parser.verify(parser.match(null, -5, false), "Expecting name of project");
        String name = t.getStringValue();
        parser.verify(parser.match(null, 123, false), "Expecting '{' to begin proejct definition");
        GosucSdk sdk = GosucSdk.parse(parser);
        parser.verify(parser.matchWord("modules", false), "Expecting 'modules' keyword");
        parser.verify(parser.match(null, 123, false), "Expecting '{' to begin module list");
        List<GosucModule> modules = GosucProject.parseModuleList(parser);
        parser.verify(parser.match(null, 125, false), "Expecting '}' to close module list");
        List<String> globalLoaders = Collections.emptyList();
        if (parser.matchWord("global-loaders", false)) {
            parser.verify(parser.match(null, 123, false), "Expecting '{' to begin global loader list");
            globalLoaders = GosucProject.parseGlobalLoaderList(parser);
            parser.verify(parser.match(null, 125, false), "Expecting '}' to close global loader list");
        }
        if (custParser != null) {
            custParser.parse(parser);
        }
        parser.verify(parser.match(null, 125, false), "Expecting '}' to close project definition");
        return custParser == null ? new GosucProject(name, sdk, modules, globalLoaders) : custParser.createProject(name, sdk, modules, globalLoaders);
    }

    private static List<GosucModule> parseModuleList(GosucProjectParser parser) {
        ArrayList<GosucModule> modules = new ArrayList<GosucModule>();
        while (parser.match(null, -5, true)) {
            modules.add(GosucModule.parse(parser));
        }
        return modules;
    }

    private static List<String> parseGlobalLoaderList(GosucProjectParser parser) {
        ArrayList<String> paths = new ArrayList<String>();
        IToken t = parser.getTokenizer().getCurrentToken();
        while (parser.match(null, 34, false)) {
            paths.add(t.getStringValue());
            if (!parser.match(null, 44, false)) break;
            t = parser.getTokenizer().getCurrentToken();
        }
        return paths;
    }

    @Override
    public Object getNativeProject() {
        return this;
    }

    @Override
    public boolean isDisposed() {
        return false;
    }

    @Override
    public boolean isHeadless() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GosucProject that = (GosucProject)o;
        if (!this._globalLoaders.equals(that._globalLoaders)) {
            return false;
        }
        if (!this._modules.equals(that._modules)) {
            return false;
        }
        if (!this._name.equals(that._name)) {
            return false;
        }
        return this._sdk.equals(that._sdk);
    }

    public int hashCode() {
        int result = this._name.hashCode();
        result = 31 * result + this._sdk.hashCode();
        result = 31 * result + this._modules.hashCode();
        result = 31 * result + this._globalLoaders.hashCode();
        return result;
    }

    public Collection<? extends CharSequence> getAllDefinedTypes() {
        ArrayList<String> types = new ArrayList<String>();
        for (GosucModule module : this._modules) {
            if (module instanceof IJreModule || module == TypeSystem.getGlobalModule()) continue;
            for (String srcRoot : module.getAllSourceRoots()) {
                File rootFile = new File(srcRoot);
                if (!rootFile.exists()) {
                    throw new RuntimeException(srcRoot + " is not a valid source root");
                }
                this.addTypesForFile(types, rootFile);
            }
        }
        return types;
    }

    private void addTypesForFile(List<String> types, File rootFile) {
        for (File f : rootFile.listFiles()) {
            if (f.isDirectory()) {
                this.addTypesForFile(types, f);
                continue;
            }
            IFile file = CommonServices.getFileSystem().getIFile(f);
            String[] typesForFile = TypeSystem.getTypesForFile(TypeSystem.getGlobalModule(), file);
            if (typesForFile.length <= 0) continue;
            for (String type : typesForFile) {
                if (type.startsWith("default.")) continue;
                types.add(type);
            }
        }
    }

    public IMemoryMonitor getMemoryMonitor() {
        return null;
    }

    @Override
    public boolean isShadowMode() {
        return false;
    }
}

