/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.reflect;

import gw.internal.gosu.util.StringPool;
import gw.lang.parser.GosuParserTypes;
import gw.lang.parser.IBlockClass;
import gw.lang.parser.IExpression;
import gw.lang.parser.IScriptPartId;
import gw.lang.parser.ScriptPartId;
import gw.lang.parser.StandardCoercionManager;
import gw.lang.parser.TypeVarToTypeMap;
import gw.lang.reflect.AbstractType;
import gw.lang.reflect.FunctionArrayType;
import gw.lang.reflect.FunctionTypeInfo;
import gw.lang.reflect.IBlockType;
import gw.lang.reflect.IDFSBackedFeatureInfo;
import gw.lang.reflect.IDynamicType;
import gw.lang.reflect.IFeatureInfo;
import gw.lang.reflect.IFunctionType;
import gw.lang.reflect.IGenericMethodInfo;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.IMethodInfoDelegate;
import gw.lang.reflect.INonLoadableType;
import gw.lang.reflect.IOptionalParamCapable;
import gw.lang.reflect.IParameterInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeInfo;
import gw.lang.reflect.ITypeLoader;
import gw.lang.reflect.ITypeVariableArrayType;
import gw.lang.reflect.ITypeVariableType;
import gw.lang.reflect.MethodInfoDelegate;
import gw.lang.reflect.Modifier;
import gw.lang.reflect.ParameterizedFunctionType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.IGenericTypeVariable;
import gw.lang.reflect.gs.IGosuClass;
import gw.lang.reflect.java.IJavaClassInfo;
import gw.lang.reflect.java.JavaTypes;
import gw.util.concurrent.LockingLazyVar;
import java.io.ObjectStreamException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class FunctionType
extends AbstractType
implements IFunctionType,
IGenericMethodInfo {
    private static final IGenericTypeVariable[] EMPTY_TYPE_VARS = new IGenericTypeVariable[0];
    private static final IType[] EMPTY_ARGS = new IType[0];
    private IType _retType;
    private volatile IType[] _paramTypes;
    private IMethodInfo _mi;
    private String _strFunctionName;
    private IScriptPartId _scriptPart;
    private IType _owningParameterizedType;
    private volatile IGenericTypeVariable[] _typeVars;
    private int _iModifiers;
    private IType _enclosingType;
    private transient FunctionTypeInfo _typeInfo;
    protected transient Set<IType> _allTypesInHierarchy;
    private transient String _signature;
    private volatile transient Map<String, ParameterizedFunctionType> _parameterizationByParamsName;
    private LockingLazyVar<FunctionArrayType> _arrType = new LockingLazyVar<FunctionArrayType>(){

        @Override
        protected FunctionArrayType init() {
            return new FunctionArrayType(FunctionType.this, FunctionType.this.getFunctionClass(), FunctionType.this.getTypeLoader());
        }
    };

    public FunctionType(String strFunctionName, IType retType, IType[] paramTypes) {
        this._retType = retType;
        if (this._retType == null) {
            this._retType = JavaTypes.pVOID();
        }
        this._paramTypes = paramTypes == null || paramTypes.length == 0 ? EMPTY_ARGS : paramTypes;
        this.setName(strFunctionName);
        this._mi = null;
        this._allTypesInHierarchy = Collections.singleton(this);
        this._typeVars = EMPTY_TYPE_VARS;
    }

    public FunctionType(String strFunctionName, IType retType, IType[] paramTypes, IGenericTypeVariable[] typeVars) {
        this(strFunctionName, retType, paramTypes);
        if (typeVars != null) {
            this._typeVars = typeVars;
            for (IGenericTypeVariable gtv : typeVars) {
                gtv.getTypeVariableDefinition().setEnclosingType(this);
            }
        }
    }

    public FunctionType(IMethodInfo mi) {
        this(mi, false);
    }

    public FunctionType(IMethodInfo mi, boolean lazyTypes) {
        this._mi = mi;
        if (!lazyTypes) {
            this.initLazyMethodInfoState_NoLock();
        }
        this.setName(mi.getDisplayName());
        IMethodInfo backingMi = mi;
        while (backingMi instanceof IMethodInfoDelegate) {
            backingMi = ((IMethodInfoDelegate)backingMi).getSource();
        }
        if (backingMi instanceof IDFSBackedFeatureInfo) {
            this._iModifiers = ((IDFSBackedFeatureInfo)((Object)backingMi)).getDfs().getModifiers();
        }
        this._allTypesInHierarchy = Collections.singleton(this);
    }

    private void setName(String name) {
        this._strFunctionName = StringPool.get(name);
    }

    private void initLazyMethodInfoState() {
        TypeSystem.lock();
        try {
            this.initLazyMethodInfoState_NoLock();
        }
        finally {
            TypeSystem.unlock();
        }
    }

    private void initLazyMethodInfoState_NoLock() {
        if (this._paramTypes == null) {
            IParameterInfo[] pd = this._mi.getParameters();
            int iArgs = pd.length;
            this._paramTypes = new IType[iArgs];
            for (int i = 0; i < iArgs; ++i) {
                this._paramTypes[i] = pd[i].getFeatureType();
            }
            if (this._paramTypes.length == 0) {
                this._paramTypes = EMPTY_ARGS;
            }
            this._typeVars = EMPTY_TYPE_VARS;
            if (this._mi instanceof IGenericMethodInfo) {
                this._typeVars = ((IGenericMethodInfo)((Object)this._mi)).getTypeVariables();
            }
            this.clearParamSignature();
        }
        this._retType = this._mi.getReturnType();
        if (this._retType == null) {
            this._retType = JavaTypes.pVOID();
        }
    }

    public FunctionType(FunctionType source, IType gsClass) {
        if (gsClass.isParameterizedType()) {
            this._owningParameterizedType = gsClass;
            TypeVarToTypeMap actualParamByVarName = TypeSystem.mapTypeByVarName(gsClass, gsClass);
            IGenericTypeVariable[] tvs = source.getTypeVariables();
            if (tvs != null) {
                for (IGenericTypeVariable tv : tvs) {
                    if (actualParamByVarName.isEmpty()) {
                        actualParamByVarName = new TypeVarToTypeMap();
                    }
                    actualParamByVarName.put(tv.getTypeVariableDefinition().getType(), tv.getTypeVariableDefinition().getType());
                }
            }
            this.assignTypeVars(source.getGenericTypeVariables(), actualParamByVarName);
            this.assignReturnTypeFromTypeParams(source, actualParamByVarName, true);
            this.assignParamTypesFromTypeParams(source, actualParamByVarName, true);
        } else {
            this._retType = source.getReturnType();
            if (this._retType == null) {
                this._retType = JavaTypes.pVOID();
            }
            this._paramTypes = source._paramTypes;
        }
        this.copyFields(source);
    }

    protected FunctionType(FunctionType source, IType returnType, IType[] paramTypes) {
        this._retType = returnType;
        this._paramTypes = paramTypes;
        this.copyFields(source);
    }

    protected FunctionType(FunctionType source, TypeVarToTypeMap actualParamByVarName, boolean bKeepTypeVars) {
        this.assignReturnTypeFromTypeParams(source, actualParamByVarName, bKeepTypeVars);
        this.assignParamTypesFromTypeParams(source, actualParamByVarName, bKeepTypeVars);
        this.copyFields(source);
        this.clearParamSignature();
    }

    protected void copyFields(FunctionType source) {
        this._mi = source._mi;
        this._strFunctionName = source._strFunctionName;
        this._scriptPart = source._scriptPart;
        this._typeVars = this._typeVars == null ? source.getGenericTypeVariables() : this._typeVars;
        this._typeInfo = source._typeInfo;
        this._allTypesInHierarchy = source._allTypesInHierarchy;
        this._signature = source._signature;
        this._parameterizationByParamsName = source._parameterizationByParamsName;
        this._enclosingType = source._enclosingType;
        this._iModifiers = source._iModifiers;
    }

    public FunctionType parameterize(FunctionType source, TypeVarToTypeMap actualParamByVarName, boolean bKeepTypeVars) {
        return new FunctionType(source, actualParamByVarName, bKeepTypeVars);
    }

    private void assignParamTypesFromTypeParams(FunctionType source, TypeVarToTypeMap actualParamByVarName, boolean bKeepTypeVars) {
        IType[] genParamTypes = source.getParameterTypes();
        if (genParamTypes != null) {
            this._paramTypes = new IType[genParamTypes.length];
            for (int j = 0; j < genParamTypes.length; ++j) {
                this._paramTypes[j] = TypeSystem.getActualType(genParamTypes[j], actualParamByVarName, bKeepTypeVars);
                if (this._paramTypes[j] != null) continue;
                this._paramTypes[j] = genParamTypes[j];
            }
            if (this._paramTypes.length == 0) {
                this._paramTypes = EMPTY_ARGS;
            }
            this.clearParamSignature();
        }
    }

    private void assignTypeVars(IGenericTypeVariable[] gtvs, TypeVarToTypeMap actualParamByVarName) {
        IGenericTypeVariable[] newGtvs = new IGenericTypeVariable[gtvs.length];
        for (int i = 0; i < gtvs.length; ++i) {
            IGenericTypeVariable gtv = gtvs[i];
            newGtvs[i] = gtv.remapBounds(actualParamByVarName);
        }
        this._typeVars = newGtvs;
    }

    private void assignReturnTypeFromTypeParams(FunctionType source, TypeVarToTypeMap actualParamByVarName, boolean bKeepTypeVars) {
        this._retType = TypeSystem.getActualType(source.getReturnType(), actualParamByVarName, bKeepTypeVars);
        if (this._retType == null) {
            this._retType = source.getReturnType();
        }
        if (this._retType == null) {
            this._retType = JavaTypes.pVOID();
        }
    }

    public IType getIntrinsicType() {
        return this.getReturnType();
    }

    @Override
    public IType getReturnType() {
        if (this._retType == null) {
            this.initLazyMethodInfoState();
        }
        return this._retType;
    }

    public void setRetType(IType retType) {
        this._retType = retType == null ? JavaTypes.pVOID() : retType;
    }

    @Override
    public IType[] getParameterTypes() {
        if (this._paramTypes == null) {
            this.initLazyMethodInfoState();
        }
        return this._paramTypes;
    }

    public void setArgumentTypes(IType[] paramTypes) {
        this._paramTypes = paramTypes == null || paramTypes.length == 0 ? EMPTY_ARGS : paramTypes;
        this.clearParamSignature();
    }

    @Override
    public IMethodInfo getMethodInfo() {
        if (this._mi == null && this.getScriptPart() != null) {
            IType type = this.getScriptPart().getContainingType();
            if (type instanceof IGosuClass) {
                IGosuClass gsClass = (IGosuClass)type;
                this._mi = gsClass.getTypeInfo().getMethod(type, this.getName(), this.getParameterTypes());
            } else if (type != null) {
                this._mi = type.getTypeInfo().getMethod(this.getName(), this.getParameterTypes());
            }
        }
        return this._mi;
    }

    @Override
    public IFeatureInfo getMethodOrConstructorInfo() {
        IType type;
        IMethodInfo mi = this.getMethodInfo();
        if (mi == null && this.getScriptPart() != null && (type = this.getScriptPart().getContainingType()) instanceof IGosuClass && type.getRelativeName().equals(this.getName())) {
            IGosuClass gsClass = (IGosuClass)type;
            return gsClass.getTypeInfo().getConstructor(type, this.getParameterTypes());
        }
        return mi;
    }

    private void clearParamSignature() {
        this._signature = null;
    }

    @Override
    public String getParamSignature() {
        if (this._signature == null) {
            IType[] paramTypes = this.getParameterTypes();
            if (paramTypes.length == 0) {
                this._signature = this._strFunctionName + "()";
                return this._signature;
            }
            String strParams = this._strFunctionName + "(";
            for (int i = 0; i < paramTypes.length; ++i) {
                strParams = strParams + (i == 0 ? "" : ", ") + (paramTypes[i] == null ? "" : paramTypes[i].getName());
            }
            strParams = strParams + ")";
            this._signature = strParams;
        }
        return this._signature;
    }

    @Override
    public String getParamSignatureForCurrentModule() {
        String sig;
        IType[] paramTypes = this.getParameterTypes();
        if (paramTypes.length == 0) {
            sig = this._strFunctionName + "()";
        } else {
            String strParams = this._strFunctionName + "(";
            for (int i = 0; i < paramTypes.length; ++i) {
                strParams = strParams + (i == 0 ? "" : ", ") + (paramTypes[i] == null ? "" : FunctionType.getParamTypeNameFromJavaBackedType(paramTypes[i]));
            }
            sig = strParams = strParams + ")";
        }
        return sig;
    }

    public static String getParamTypeNameFromJavaBackedType(IType paramType) {
        return TypeSystem.getTypeFromJavaBackedType(paramType).getName();
    }

    @Override
    public String getName() {
        return this._strFunctionName;
    }

    @Override
    public String getDisplayName() {
        return this.getName();
    }

    @Override
    public String getRelativeName() {
        return this.getName();
    }

    @Override
    public String getNamespace() {
        IType enclosingType = this.getEnclosingType();
        return enclosingType != null ? enclosingType.getName() : null;
    }

    @Override
    public ITypeLoader getTypeLoader() {
        return null;
    }

    @Override
    public boolean isInterface() {
        return false;
    }

    @Override
    public IType[] getInterfaces() {
        return EMPTY_TYPE_ARRAY;
    }

    @Override
    public boolean isEnum() {
        return false;
    }

    @Override
    public IType getSupertype() {
        return null;
    }

    @Override
    public IType getEnclosingType() {
        IType type = null;
        if (this._scriptPart != null && (type = this._scriptPart.getContainingType()) != null) {
            return type;
        }
        IFeatureInfo methodInfo = this.getMethodOrConstructorInfo();
        if (methodInfo != null) {
            return methodInfo.getOwnersType();
        }
        return this._enclosingType;
    }

    @Override
    public IType getGenericType() {
        return this.isGenericType() ? this : null;
    }

    @Override
    public boolean isFinal() {
        return false;
    }

    @Override
    public boolean isParameterizedType() {
        return false;
    }

    @Override
    public boolean isGenericType() {
        return this.getGenericTypeVariables().length > 0;
    }

    @Override
    public IGenericTypeVariable[] getGenericTypeVariables() {
        if (this._typeVars == null) {
            this.initLazyMethodInfoState();
        }
        return this._typeVars;
    }

    @Override
    public ParameterizedFunctionType getParameterizedType(IType ... typeParams) {
        String strNameOfParams;
        ParameterizedFunctionType parameterizedType;
        if (typeParams == null || typeParams.length == 0) {
            throw new IllegalArgumentException("Parameter types required.");
        }
        if (this._parameterizationByParamsName == null) {
            TypeSystem.lock();
            try {
                if (this._parameterizationByParamsName == null) {
                    this._parameterizationByParamsName = new ConcurrentHashMap<String, ParameterizedFunctionType>(2);
                }
            }
            finally {
                TypeSystem.unlock();
            }
        }
        if ((parameterizedType = this._parameterizationByParamsName.get(strNameOfParams = TypeSystem.getNameOfParams(typeParams, false, true))) == null) {
            parameterizedType = new ParameterizedFunctionType(this, typeParams);
            this._parameterizationByParamsName.put(strNameOfParams, parameterizedType);
        }
        return parameterizedType;
    }

    @Override
    public IFunctionType inferParameterizedTypeFromArgTypesAndContextType(IType[] argTypes, IType ctxType) {
        IGenericTypeVariable[] typeVars;
        TypeVarToTypeMap map = TypeVarToTypeMap.EMPTY_MAP;
        if (argTypes.length > 0) {
            map = this.getMethodInfo() == null ? this.inferTypeParametersFromArgumentTypes(argTypes) : ((IGenericMethodInfo)((Object)this.getMethodInfo())).inferTypeParametersFromArgumentTypes2(this._owningParameterizedType, argTypes);
        }
        if ((typeVars = this.getGenericTypeVariables()).length == 0) {
            return this;
        }
        IType[] typeParams = new IType[typeVars.length];
        for (int i = 0; i < typeVars.length; ++i) {
            IGenericTypeVariable typeVar = typeVars[i];
            IType inferredType = map.get(typeVar.getTypeVariableDefinition().getType());
            if (inferredType == null && ctxType != null) {
                TypeVarToTypeMap returnTypeVars = new TypeVarToTypeMap();
                TypeSystem.inferTypeVariableTypesFromGenParamTypeAndConcreteType(this.getReturnType(), ctxType, returnTypeVars, false);
                ITypeVariableType typeVarType = typeVar.getTypeVariableDefinition().getType();
                inferredType = returnTypeVars.get(typeVarType);
                if (inferredType == null || !typeVar.getBoundingType().isAssignableFrom(inferredType)) {
                    inferredType = TypeSystem.replaceTypeVariableTypeParametersWithBoundingTypes(typeVar.getBoundingType(), this.getEnclosingType());
                }
            }
            typeParams[i] = inferredType;
            if (typeParams[i] != null) continue;
            return this;
        }
        return this.getParameterizedType(typeParams);
    }

    @Override
    public IType[] getTypeParameters() {
        return null;
    }

    public Set<IType> getAllTypesInHierarchy() {
        return this._allTypesInHierarchy;
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public IType getArrayType() {
        return this._arrType.get();
    }

    @Override
    public Object makeArrayInstance(int iLength) {
        return TypeSystem.get(this.getFunctionClass()).makeArrayInstance(iLength);
    }

    private IJavaClassInfo getFunctionClass() {
        return TypeSystem.getGosuClassLoader().getFunctionClassForArity(this.getReturnType() != JavaTypes.pVOID(), this.getParameterTypes().length).getBackingClassInfo();
    }

    @Override
    public Object getArrayComponent(Object array, int iIndex) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        return TypeSystem.get(this.getFunctionClass()).getArrayComponent(array, iIndex);
    }

    @Override
    public void setArrayComponent(Object array, int iIndex, Object value) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        TypeSystem.get(this.getFunctionClass()).setArrayComponent(array, iIndex, value);
    }

    @Override
    public int getArrayLength(Object array) throws IllegalArgumentException {
        return TypeSystem.get(this.getFunctionClass()).getArrayLength(array);
    }

    @Override
    public IType getComponentType() {
        return null;
    }

    @Override
    public boolean isAssignableFrom(IType type) {
        return this.isAssignableFrom(type, true);
    }

    @Override
    public boolean isAssignableFrom(IType type, boolean bContravariant) {
        FunctionType that;
        if (this == type) {
            return true;
        }
        if (type instanceof IBlockClass) {
            return this.isAssignableFrom(((IBlockClass)type).getBlockType());
        }
        if (type instanceof FunctionType && FunctionType.areParamsCompatible(this, that = (FunctionType)type, bContravariant)) {
            return this.areReturnTypesAssignable(that);
        }
        return false;
    }

    protected boolean areReturnTypesAssignable(FunctionType from) {
        IType fromType;
        IType toType = this.getReturnType();
        if (this.isThisReturnTypeNotVoidThatReturnTypeVoid(toType, fromType = from.getReturnType())) {
            return false;
        }
        return toType == fromType || toType.isAssignableFrom(fromType) || StandardCoercionManager.isStructurallyAssignable(toType, fromType) || StandardCoercionManager.arePrimitiveTypesAssignable(toType, fromType) || toType == GosuParserTypes.NULL_TYPE();
    }

    private boolean isThisReturnTypeNotVoidThatReturnTypeVoid(IType toType, IType fromType) {
        return toType != JavaTypes.pVOID() && toType != JavaTypes.VOID() && (fromType == JavaTypes.pVOID() || fromType == JavaTypes.VOID());
    }

    @Override
    public boolean areParamsCompatible(IFunctionType fromType) {
        return FunctionType.areParamsCompatible(this, fromType);
    }

    public static boolean areParamsCompatible(IFunctionType toType, IFunctionType fromType) {
        return FunctionType.areParamsCompatible(toType, fromType, true);
    }

    private static boolean areParamsCompatible(IFunctionType toType, IFunctionType fromType, boolean bContravariant) {
        IType[] fromParams;
        IType[] toParams = toType.getParameterTypes();
        if (toParams.length != (fromParams = fromType.getParameterTypes()).length) {
            return false;
        }
        for (int i = 0; i < fromParams.length; ++i) {
            IType toParamType = toParams[i];
            IType fromParamType = fromParams[i];
            if (!(bContravariant ? !StandardCoercionManager.arePrimitiveTypesAssignable(fromParamType, toParamType) && !(toParamType instanceof ITypeVariableType) && !fromParamType.isAssignableFrom(toParamType) && !StandardCoercionManager.isStructurallyAssignable(fromParamType, toParamType) && !fromParamType.isDynamic() && !toParamType.isDynamic() : !fromParamType.equals(toParamType) && !(toParamType instanceof ITypeVariableType))) continue;
            return false;
        }
        return true;
    }

    public static IType[] findContravariantParams(IType[] lhsParams, IType[] rhsParams) {
        if (lhsParams.length != rhsParams.length) {
            return null;
        }
        IType[] types = new IType[lhsParams.length];
        for (int i = 0; i < rhsParams.length; ++i) {
            IType otherParamType = rhsParams[i];
            IType myParamType = lhsParams[i];
            if (StandardCoercionManager.arePrimitiveTypesAssignable(otherParamType, myParamType)) {
                types[i] = myParamType;
                continue;
            }
            if (StandardCoercionManager.arePrimitiveTypesAssignable(myParamType, otherParamType)) {
                types[i] = otherParamType;
                continue;
            }
            if (otherParamType.isAssignableFrom(myParamType)) {
                types[i] = myParamType;
                continue;
            }
            if (myParamType.isAssignableFrom(myParamType)) {
                types[i] = otherParamType;
                continue;
            }
            if (otherParamType.isDynamic() || myParamType.isDynamic()) {
                types[i] = IDynamicType.instance();
                continue;
            }
            return null;
        }
        return types;
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public ITypeInfo getTypeInfo() {
        return this._typeInfo == null ? (this._typeInfo = new FunctionTypeInfo(this)) : this._typeInfo;
    }

    @Override
    public void unloadTypeInfo() {
        this._typeInfo = null;
    }

    @Override
    public Object readResolve() throws ObjectStreamException {
        return this;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public int getModifiers() {
        if (this._iModifiers == 0) {
            return this._mi != null ? Modifier.getModifiersFrom(this._mi) : 1;
        }
        return this._iModifiers;
    }

    public void setModifiers(int iModifiers) {
        this._iModifiers = iModifiers;
    }

    @Override
    public boolean isAbstract() {
        return false;
    }

    @Override
    public IScriptPartId getScriptPart() {
        return this._scriptPart;
    }

    @Override
    public IType newInstance(IType[] paramTypes, IType returnType) {
        FunctionType functionType = new FunctionType(this._strFunctionName, returnType, paramTypes, this.cloneTypeVars());
        functionType._iModifiers = this._iModifiers;
        if (this.getScriptPart() == null && this._mi != null) {
            if (this._mi instanceof MethodInfoDelegate) {
                functionType.setScriptPart(new ScriptPartId(((MethodInfoDelegate)this._mi).getSource().getOwnersType(), null));
            } else {
                functionType.setScriptPart(new ScriptPartId(this._mi.getOwnersType(), null));
            }
        } else {
            functionType.setScriptPart(this.getScriptPart());
        }
        return functionType;
    }

    private IGenericTypeVariable[] cloneTypeVars() {
        IGenericTypeVariable[] typeVars = new IGenericTypeVariable[this._typeVars.length];
        for (int i = 0; i < typeVars.length; ++i) {
            typeVars[i] = this._typeVars[i].copy();
        }
        return typeVars;
    }

    public void setScriptPart(IScriptPartId scriptPart) {
        this._scriptPart = scriptPart;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!this.getClass().isInstance(o)) {
            return false;
        }
        FunctionType funcType = (FunctionType)o;
        if (!(funcType.getDisplayName().equals(this.getDisplayName()) || o instanceof IBlockType || this instanceof IBlockType)) {
            return false;
        }
        if (!this.areEnclosingTypesEqual(funcType)) {
            return false;
        }
        if (this.isGenericType() != funcType.isGenericType()) {
            return false;
        }
        if (this.isGenericType()) {
            IGenericTypeVariable[] thatGtvs;
            IGenericTypeVariable[] gtvs = this.getGenericTypeVariables();
            if (gtvs.length != (thatGtvs = funcType.getGenericTypeVariables()).length) {
                return false;
            }
            for (int i = 0; i < gtvs.length; ++i) {
                if (gtvs[i].equals(thatGtvs[i])) continue;
                return false;
            }
        }
        if (funcType.getParameterTypes().length != this.getParameterTypes().length) {
            return false;
        }
        for (int i = 0; i < this.getParameterTypes().length; ++i) {
            if (this.areSameTypes(this.getParameterTypes()[i], funcType.getParameterTypes()[i])) continue;
            return false;
        }
        return this.areSameTypes(this.getReturnType(), funcType.getReturnType());
    }

    protected boolean areEnclosingTypesEqual(FunctionType funcType) {
        if (this.areSameTypes(this.getEnclosingType(), funcType.getEnclosingType())) {
            return true;
        }
        return this.getEnclosingType() == null || funcType.getEnclosingType() == null;
    }

    protected boolean areSameTypes(IType t1, IType t2) {
        return t1 instanceof INonLoadableType ? t1.equals(t2) : t1 == t2;
    }

    public int hashCode() {
        int result = this.getDisplayName().hashCode();
        for (int i = 0; i < this.getParameterTypes().length; ++i) {
            result = this.getParameterTypes()[i] instanceof INonLoadableType ? 31 * result + this.getParameterTypes()[i].hashCode() : 31 * result + this.getParameterTypes()[i].getName().hashCode();
        }
        result = this.getReturnType() instanceof INonLoadableType ? 31 * result + this.getReturnType().hashCode() : 31 * result + this.getReturnType().getName().hashCode();
        return result;
    }

    public String toString() {
        return this.getParamSignature().toString() + ":" + this.getReturnType().getName();
    }

    @Override
    public TypeVarToTypeMap inferTypeParametersFromArgumentTypes2(IType owningParameterizedType, IType ... argTypes) {
        return this.inferTypeParametersFromArgumentTypes(argTypes);
    }

    @Override
    public TypeVarToTypeMap inferTypeParametersFromArgumentTypes(IType ... argTypes) {
        IType[] genParamTypes = this.getParameterTypes();
        TypeVarToTypeMap map = new TypeVarToTypeMap();
        for (int i = 0; i < argTypes.length; ++i) {
            if (genParamTypes.length <= i) continue;
            TypeSystem.inferTypeVariableTypesFromGenParamTypeAndConcreteType(genParamTypes[i], argTypes[i], map, false);
        }
        return map;
    }

    @Override
    public IGenericTypeVariable[] getTypeVariables() {
        return this.getGenericTypeVariables();
    }

    @Override
    public IType getParameterizedReturnType(IType ... typeParams) {
        TypeVarToTypeMap actualParamByVarName = new TypeVarToTypeMap();
        int i = 0;
        for (IGenericTypeVariable tv : this.getTypeVariables()) {
            actualParamByVarName.put(tv.getTypeVariableDefinition().getType(), typeParams[i++]);
        }
        return TypeSystem.getActualType(this.getReturnType(), actualParamByVarName, false);
    }

    @Override
    public IType[] getParameterizedParameterTypes(IType ... typeParams) {
        return this.getParameterizedParameterTypes2(null, typeParams);
    }

    @Override
    public IType[] getParameterizedParameterTypes2(IType ownersType, IType ... typeParams) {
        TypeVarToTypeMap actualParamByVarName = new TypeVarToTypeMap();
        int i = 0;
        for (IGenericTypeVariable tv : this.getTypeVariables()) {
            actualParamByVarName.put(tv.getTypeVariableDefinition().getType(), typeParams[i++]);
        }
        IType[] genParamTypes = this.getParameterTypes();
        IType[] paramTypes = new IType[genParamTypes.length];
        for (int j = 0; j < genParamTypes.length; ++j) {
            paramTypes[j] = TypeSystem.getActualType(genParamTypes[j], actualParamByVarName, false);
        }
        return paramTypes;
    }

    public FunctionType getRuntimeType() {
        TypeVarToTypeMap actualParamByVarName = new TypeVarToTypeMap();
        actualParamByVarName = this.mapTypes(actualParamByVarName, this.getParameterTypes());
        return (actualParamByVarName = this.mapTypes(actualParamByVarName, this.getReturnType())).size() != 0 ? this.parameterize(this, actualParamByVarName, false) : this;
    }

    private TypeVarToTypeMap mapTypes(TypeVarToTypeMap actualParamByVarName, IType ... types) {
        for (int i = 0; i < types.length; ++i) {
            IType[] paramTypes;
            IType type = types[i];
            if (type instanceof ITypeVariableType) {
                actualParamByVarName.put((ITypeVariableType)types[i], types[i]);
            }
            if (type instanceof ITypeVariableArrayType) {
                this.mapTypes(actualParamByVarName, type.getComponentType());
            }
            if (type.isParameterizedType()) {
                IType[] parameters = type.getTypeParameters();
                this.mapTypes(actualParamByVarName, parameters);
            }
            if (!(type instanceof IFunctionType)) continue;
            IFunctionType funType = (IFunctionType)type;
            this.mapTypes(actualParamByVarName, funType.getReturnType());
            for (IType paramType : paramTypes = funType.getParameterTypes()) {
                this.mapTypes(actualParamByVarName, paramType);
            }
        }
        return actualParamByVarName;
    }

    @Override
    public boolean isDiscarded() {
        return false;
    }

    @Override
    public void setDiscarded(boolean bDiscarded) {
    }

    @Override
    public boolean isCompoundType() {
        return false;
    }

    @Override
    public Set<IType> getCompoundTypeComponents() {
        return null;
    }

    @Override
    public IExpression[] getDefaultValueExpressions() {
        if (this.getMethodOrConstructorInfo() instanceof IOptionalParamCapable) {
            return ((IOptionalParamCapable)((Object)this.getMethodOrConstructorInfo())).getDefaultValueExpressions();
        }
        return IExpression.EMPTY_ARRAY;
    }

    @Override
    public boolean hasOptionalParams() {
        for (IExpression o : this.getDefaultValueExpressions()) {
            if (o == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public String[] getParameterNames() {
        IFeatureInfo miOrCi = this.getMethodOrConstructorInfo();
        if (miOrCi instanceof IOptionalParamCapable) {
            return ((IOptionalParamCapable)((Object)miOrCi)).getParameterNames();
        }
        return new String[0];
    }

    public IType getOwningParameterizedType() {
        return this._owningParameterizedType;
    }

    public void setEnclosingType(IType gosuClass) {
        this._enclosingType = gosuClass;
    }
}

