/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.reflect.java.asm;

import gw.internal.ext.org.objectweb.asm.signature.SignatureVisitor;
import gw.lang.reflect.java.asm.AsmMethod;
import gw.lang.reflect.java.asm.AsmType;
import gw.lang.reflect.java.asm.AsmUtil;
import gw.lang.reflect.java.asm.DeclarationPartSignatureVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MethodDeclarationSignatureVisitor
extends SignatureVisitor {
    private final AsmMethod _asmMethod;
    private AsmType _csrTypeVar;
    private List<DeclarationPartSignatureVisitor> _paramVisitors;
    private DeclarationPartSignatureVisitor _returnVisitor;
    private List<DeclarationPartSignatureVisitor> _exceptionVisitors;

    MethodDeclarationSignatureVisitor(AsmMethod asmMethod) {
        super(458752);
        this._asmMethod = asmMethod;
        this._paramVisitors = Collections.emptyList();
        this._exceptionVisitors = Collections.emptyList();
    }

    public List<DeclarationPartSignatureVisitor> getParamVisitors() {
        return this._paramVisitors;
    }

    public DeclarationPartSignatureVisitor getReturnVisitor() {
        return this._returnVisitor;
    }

    public List<DeclarationPartSignatureVisitor> getExceptionVisitors() {
        return this._exceptionVisitors;
    }

    public void visitFormalTypeParameter(String tv) {
        this._csrTypeVar = AsmUtil.makeTypeVariable(tv);
        this._asmMethod.setGeneric();
        this._csrTypeVar.setFunctionTypeVariable(true);
        this._asmMethod.getMethodType().addTypeParameter(this._csrTypeVar);
    }

    public SignatureVisitor visitClassBound() {
        return new DeclarationPartSignatureVisitor(this._csrTypeVar);
    }

    public SignatureVisitor visitInterfaceBound() {
        return new DeclarationPartSignatureVisitor(this._csrTypeVar);
    }

    public SignatureVisitor visitParameterType() {
        if (this._paramVisitors.isEmpty()) {
            this._paramVisitors = new ArrayList<DeclarationPartSignatureVisitor>();
        }
        DeclarationPartSignatureVisitor visitor = new DeclarationPartSignatureVisitor(this._asmMethod);
        this._paramVisitors.add(visitor);
        return visitor;
    }

    public SignatureVisitor visitReturnType() {
        this._asmMethod.initGenericReturnType();
        this._returnVisitor = new DeclarationPartSignatureVisitor(this._asmMethod);
        return this._returnVisitor;
    }

    public SignatureVisitor visitExceptionType() {
        if (this._exceptionVisitors.isEmpty()) {
            this._exceptionVisitors = new ArrayList<DeclarationPartSignatureVisitor>();
        }
        DeclarationPartSignatureVisitor visitor = new DeclarationPartSignatureVisitor(this._asmMethod);
        this._exceptionVisitors.add(visitor);
        return visitor;
    }
}

