/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.ir.expression;

import gw.lang.UnstableAPI;
import gw.lang.ir.IRExpression;
import gw.lang.ir.IRType;

@UnstableAPI
public class IRArithmeticExpression
extends IRExpression {
    private IRType _type;
    private IRExpression _lhs;
    private IRExpression _rhs;
    private Operation _op;

    public IRArithmeticExpression(IRType type, IRExpression lhs, IRExpression rhs, Operation op) {
        this._type = type;
        this._lhs = lhs;
        this._rhs = rhs;
        this._op = op;
        lhs.setParent(this);
        rhs.setParent(this);
    }

    @Override
    public IRType getType() {
        return this._type;
    }

    public IRExpression getLhs() {
        return this._lhs;
    }

    public IRExpression getRhs() {
        return this._rhs;
    }

    public Operation getOp() {
        return this._op;
    }

    public static enum Operation {
        Addition("+"),
        Subtraction("-"),
        Multiplication("*"),
        Division("/"),
        Remainder("%"),
        ShiftLeft("<<"),
        ShiftRight(">>"),
        UnsignedShiftRight(">>>"),
        BitwiseAnd("&"),
        BitwiseOr("|"),
        BitwiseXor("^");

        private String _op;

        private Operation(String op) {
            this._op = op;
        }

        public static Operation fromString(String op) {
            if (op.charAt(0) == '?') {
                op = op.substring(1);
            }
            if (op.equals("+") || op.equals("!+")) {
                return Addition;
            }
            if (op.equals("-") || op.equals("!-")) {
                return Subtraction;
            }
            if (op.equals("*") || op.equals("!*")) {
                return Multiplication;
            }
            if (op.equals("/")) {
                return Division;
            }
            if (op.equals("%")) {
                return Remainder;
            }
            if (op.equals("<<")) {
                return ShiftLeft;
            }
            if (op.equals(">>")) {
                return ShiftRight;
            }
            if (op.equals(">>>")) {
                return UnsignedShiftRight;
            }
            if (op.equals("&")) {
                return BitwiseAnd;
            }
            if (op.equals("|")) {
                return BitwiseOr;
            }
            if (op.equals("^")) {
                return BitwiseXor;
            }
            throw new IllegalStateException("Undefined operator: " + op);
        }
    }
}

