package gw.util.money

uses java.util.Currency

interface IMoneyConstants {
  var AED: Currency = getCurrency( "AED" )
  var AFN: Currency = getCurrency( "AFN" )
  var ALL: Currency = getCurrency( "ALL" )
  var AMD: Currency = getCurrency( "AMD" )
  var ANG: Currency = getCurrency( "ANG" )
  var AOA: Currency = getCurrency( "AOA" )
  var ARS: Currency = getCurrency( "ARS" )
  var AUD: Currency = getCurrency( "AUD" )
  var AWG: Currency = getCurrency( "AWG" )
  var AZN: Currency = getCurrency( "AZN" )
  var BAM: Currency = getCurrency( "BAM" )
  var BBD: Currency = getCurrency( "BBD" )
  var BDT: Currency = getCurrency( "BDT" )
  var BGN: Currency = getCurrency( "BGN" )
  var BHD: Currency = getCurrency( "BHD" )
  var BIF: Currency = getCurrency( "BIF" )
  var BMD: Currency = getCurrency( "BMD" )
  var BND: Currency = getCurrency( "BND" )
  var BOB: Currency = getCurrency( "BOB" )
  var BRL: Currency = getCurrency( "BRL" )
  var BSD: Currency = getCurrency( "BSD" )
  var BTN: Currency = getCurrency( "BTN" )
  var BWP: Currency = getCurrency( "BWP" )
  var BYR: Currency = getCurrency( "BYR" )
  var BZD: Currency = getCurrency( "BZD" )
  var CAD: Currency = getCurrency( "CAD" )
  var CDF: Currency = getCurrency( "CDF" )
  var CHF: Currency = getCurrency( "CHF" )
  var CLF: Currency = getCurrency( "CLF" )
  var CLP: Currency = getCurrency( "CLP" )
  var CNH: Currency = getCurrency( "CNH" )
  var CNY: Currency = getCurrency( "CNY" )
  var COP: Currency = getCurrency( "COP" )
  var CRC: Currency = getCurrency( "CRC" )
  var CUP: Currency = getCurrency( "CUP" )
  var CVE: Currency = getCurrency( "CVE" )
  var CYP: Currency = getCurrency( "CYP" )
  var CZK: Currency = getCurrency( "CZK" )
  var DEM: Currency = getCurrency( "DEM" )
  var DJF: Currency = getCurrency( "DJF" )
  var DKK: Currency = getCurrency( "DKK" )
  var DOP: Currency = getCurrency( "DOP" )
  var DZD: Currency = getCurrency( "DZD" )
  var ECS: Currency = getCurrency( "ECS" )
  var EGP: Currency = getCurrency( "EGP" )
  var ERN: Currency = getCurrency( "ERN" )
  var ETB: Currency = getCurrency( "ETB" )
  var EUR: Currency = getCurrency( "EUR" )
  var FJD: Currency = getCurrency( "FJD" )
  var FKP: Currency = getCurrency( "FKP" )
  var FRF: Currency = getCurrency( "FRF" )
  var GBP: Currency = getCurrency( "GBP" )
  var GEL: Currency = getCurrency( "GEL" )
  var GHS: Currency = getCurrency( "GHS" )
  var GIP: Currency = getCurrency( "GIP" )
  var GMD: Currency = getCurrency( "GMD" )
  var GNF: Currency = getCurrency( "GNF" )
  var GTQ: Currency = getCurrency( "GTQ" )
  var GYD: Currency = getCurrency( "GYD" )
  var HKD: Currency = getCurrency( "HKD" )
  var HNL: Currency = getCurrency( "HNL" )
  var HRK: Currency = getCurrency( "HRK" )
  var HTG: Currency = getCurrency( "HTG" )
  var HUF: Currency = getCurrency( "HUF" )
  var IDR: Currency = getCurrency( "IDR" )
  var IEP: Currency = getCurrency( "IEP" )
  var ILS: Currency = getCurrency( "ILS" )
  var INR: Currency = getCurrency( "INR" )
  var IQD: Currency = getCurrency( "IQD" )
  var IRR: Currency = getCurrency( "IRR" )
  var ISK: Currency = getCurrency( "ISK" )
  var ITL: Currency = getCurrency( "ITL" )
  var JMD: Currency = getCurrency( "JMD" )
  var JOD: Currency = getCurrency( "JOD" )
  var JPY: Currency = getCurrency( "JPY" )
  var KES: Currency = getCurrency( "KES" )
  var KGS: Currency = getCurrency( "KGS" )
  var KHR: Currency = getCurrency( "KHR" )
  var KMF: Currency = getCurrency( "KMF" )
  var KPW: Currency = getCurrency( "KPW" )
  var KRW: Currency = getCurrency( "KRW" )
  var KWD: Currency = getCurrency( "KWD" )
  var KYD: Currency = getCurrency( "KYD" )
  var KZT: Currency = getCurrency( "KZT" )
  var LAK: Currency = getCurrency( "LAK" )
  var LBP: Currency = getCurrency( "LBP" )
  var LKR: Currency = getCurrency( "LKR" )
  var LRD: Currency = getCurrency( "LRD" )
  var LSL: Currency = getCurrency( "LSL" )
  var LTL: Currency = getCurrency( "LTL" )
  var LVL: Currency = getCurrency( "LVL" )
  var LYD: Currency = getCurrency( "LYD" )
  var MAD: Currency = getCurrency( "MAD" )
  var MDL: Currency = getCurrency( "MDL" )
  var MGA: Currency = getCurrency( "MGA" )
  var MKD: Currency = getCurrency( "MKD" )
  var MMK: Currency = getCurrency( "MMK" )
  var MNT: Currency = getCurrency( "MNT" )
  var MOP: Currency = getCurrency( "MOP" )
  var MRO: Currency = getCurrency( "MRO" )
  var MUR: Currency = getCurrency( "MUR" )
  var MVR: Currency = getCurrency( "MVR" )
  var MWK: Currency = getCurrency( "MWK" )
  var MXN: Currency = getCurrency( "MXN" )
  var MXV: Currency = getCurrency( "MXV" )
  var MYR: Currency = getCurrency( "MYR" )
  var MZN: Currency = getCurrency( "MZN" )
  var NAD: Currency = getCurrency( "NAD" )
  var NGN: Currency = getCurrency( "NGN" )
  var NIO: Currency = getCurrency( "NIO" )
  var NOK: Currency = getCurrency( "NOK" )
  var NPR: Currency = getCurrency( "NPR" )
  var NZD: Currency = getCurrency( "NZD" )
  var OMR: Currency = getCurrency( "OMR" )
  var PAB: Currency = getCurrency( "PAB" )
  var PEN: Currency = getCurrency( "PEN" )
  var PGK: Currency = getCurrency( "PGK" )
  var PHP: Currency = getCurrency( "PHP" )
  var PKR: Currency = getCurrency( "PKR" )
  var PLN: Currency = getCurrency( "PLN" )
  var PYG: Currency = getCurrency( "PYG" )
  var QAR: Currency = getCurrency( "QAR" )
  var RON: Currency = getCurrency( "RON" )
  var RSD: Currency = getCurrency( "RSD" )
  var RUB: Currency = getCurrency( "RUB" )
  var RWF: Currency = getCurrency( "RWF" )
  var SAR: Currency = getCurrency( "SAR" )
  var SBD: Currency = getCurrency( "SBD" )
  var SCR: Currency = getCurrency( "SCR" )
  var SDG: Currency = getCurrency( "SDG" )
  var SEK: Currency = getCurrency( "SEK" )
  var SGD: Currency = getCurrency( "SGD" )
  var SHP: Currency = getCurrency( "SHP" )
  var SIT: Currency = getCurrency( "SIT" )
  var SLL: Currency = getCurrency( "SLL" )
  var SOS: Currency = getCurrency( "SOS" )
  var SRD: Currency = getCurrency( "SRD" )
  var STD: Currency = getCurrency( "STD" )
  var SVC: Currency = getCurrency( "SVC" )
  var SYP: Currency = getCurrency( "SYP" )
  var SZL: Currency = getCurrency( "SZL" )
  var THB: Currency = getCurrency( "THB" )
  var TJS: Currency = getCurrency( "TJS" )
  var TMT: Currency = getCurrency( "TMT" )
  var TND: Currency = getCurrency( "TND" )
  var TOP: Currency = getCurrency( "TOP" )
  var TRY: Currency = getCurrency( "TRY" )
  var TTD: Currency = getCurrency( "TTD" )
  var TWD: Currency = getCurrency( "TWD" )
  var TZS: Currency = getCurrency( "TZS" )
  var UAH: Currency = getCurrency( "UAH" )
  var UGX: Currency = getCurrency( "UGX" )
  var USD: Currency = getCurrency( "USD" )
  var UYU: Currency = getCurrency( "UYU" )
  var UZS: Currency = getCurrency( "UZS" )
  var VEF: Currency = getCurrency( "VEF" )
  var VND: Currency = getCurrency( "VND" )
  var VUV: Currency = getCurrency( "VUV" )
  var WST: Currency = getCurrency( "WST" )
  var XAF: Currency = getCurrency( "XAF" )
  var XAG: Currency = getCurrency( "XAG" )
  var XAU: Currency = getCurrency( "XAU" )
  var XCD: Currency = getCurrency( "XCD" )
  var XCP: Currency = getCurrency( "XCP" )
  var XDR: Currency = getCurrency( "XDR" )
  var XOF: Currency = getCurrency( "XOF" )
  var XPD: Currency = getCurrency( "XPD" )
  var XPF: Currency = getCurrency( "XPF" )
  var XPT: Currency = getCurrency( "XPT" )
  var YER: Currency = getCurrency( "YER" )
  var ZAR: Currency = getCurrency( "ZAR" )
  var ZMW: Currency = getCurrency( "ZMW" )
  var ZWL: Currency = getCurrency( "ZWL" )
          
  static function getCurrency( code: String ) : Currency {
    var currency: Currency
    try {
      currency = Currency.getInstance( code )
    }
    catch( e: IllegalArgumentException ) {
      currency = null
    }
    return currency
  }
}