package gw.util.science

uses gw.util.science.Charge //to prevent conflict with Guidewire's entity.Charge type
uses gw.util.Rational

uses java.math.RoundingMode
uses java.math.MathContext

final class Capacitance extends AbstractMeasure<CapacitanceUnit, Capacitance> {
  construct( value : Rational, unit: CapacitanceUnit, displayUnit: CapacitanceUnit ) {
    super( value, unit, displayUnit, CapacitanceUnit.BASE )
  }
  construct( value : Rational, unit: CapacitanceUnit ) {
    this( value, unit, unit )
  }

  function multiply( potential: Potential ) : Charge {
    return new Charge( toBaseNumber() * potential.toBaseNumber(), ChargeUnit.BASE, Unit.ChargeUnit )
  }
}
