/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.ir.builder.expression;

import gw.lang.UnstableAPI;
import gw.lang.ir.IJavaClassIRType;
import gw.lang.ir.IRExpression;
import gw.lang.ir.IRType;
import gw.lang.ir.builder.IRArgConverter;
import gw.lang.ir.builder.IRBuilderContext;
import gw.lang.ir.builder.IRExpressionBuilder;
import gw.lang.ir.expression.IRNewExpression;
import gw.lang.reflect.java.IJavaClassConstructor;
import gw.lang.reflect.java.IJavaClassInfo;
import java.util.ArrayList;
import java.util.List;

@UnstableAPI
public class IRNewExpressionBuilder
extends IRExpressionBuilder {
    private BuilderImpl _builderImpl;

    public IRNewExpressionBuilder(IRType ownersType, List<IRExpressionBuilder> args) {
        this._builderImpl = new TypeAndArgsBuilder(ownersType, args);
    }

    @Override
    protected IRExpression buildImpl(IRBuilderContext context) {
        return this._builderImpl.buildImpl(context);
    }

    private static final class TypeAndArgsBuilder
    implements BuilderImpl {
        private IRType _type;
        private List<IRExpressionBuilder> _args;

        private TypeAndArgsBuilder(IRType type, List<IRExpressionBuilder> args) {
            this._type = type;
            this._args = args;
        }

        @Override
        public IRNewExpression buildImpl(IRBuilderContext context) {
            if (this._type instanceof IJavaClassIRType) {
                IJavaClassConstructor cons = IRNewExpressionBuilder.findConstructor(((IJavaClassIRType)this._type).getJavaClassInfo(), this._args.size());
                IJavaClassInfo[] paramTypes = cons.getParameterTypes();
                ArrayList<IRExpression> args = new ArrayList<IRExpression>();
                for (int i = 0; i < this._args.size(); ++i) {
                    args.add(IRArgConverter.castOrConvertIfNecessary(IRNewExpressionBuilder.getIRType(paramTypes[i]), this._args.get(i).build(context)));
                }
                return new IRNewExpression(this._type, IRNewExpressionBuilder.getIRTypes(paramTypes), args);
            }
            throw new IllegalArgumentException("Cannot reference a method only by name on a root expression that's not an IJavaClassIRType");
        }
    }

    private static interface BuilderImpl {
        public IRNewExpression buildImpl(IRBuilderContext var1);
    }
}

