/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.reflect.interval;

import gw.lang.reflect.interval.ISequenceable;
import gw.lang.reflect.interval.IterableInterval;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class SequenceableInterval<E extends ISequenceable<E, S, U> & Comparable<E>, S, U>
extends IterableInterval<E, S, U, SequenceableInterval<E, S, U>> {
    public SequenceableInterval(E left, E right, S step, U unit, boolean bLeftClosed, boolean bRightClosed, boolean bReverse) {
        super(left, right, step, unit, bReverse ? bRightClosed : bLeftClosed, bReverse ? bLeftClosed : bRightClosed, bReverse);
    }

    @Override
    public Iterator<E> iterateFromLeft() {
        return new SequenceableIterator();
    }

    @Override
    public Iterator<E> iterateFromRight() {
        return new ReverseSequenceableIterator();
    }

    @Override
    public E getFromLeft(int iStepIndex) {
        if (iStepIndex < 0) {
            throw new IllegalArgumentException("Step index must be >= 0: " + iStepIndex);
        }
        if (!this.isLeftClosed()) {
            ++iStepIndex;
        }
        Object value = ((ISequenceable)this.getLeftEndpoint()).nextNthInSequence(this.getStep(), this.getUnit(), iStepIndex);
        int iComp = value.compareTo((ISequenceable)((ISequenceable)this.getRightEndpoint()));
        if (this.isRightClosed() ? iComp <= 0 : iComp < 0) {
            return value;
        }
        return null;
    }

    @Override
    public E getFromRight(int iStepIndex) {
        if (iStepIndex < 0) {
            throw new IllegalArgumentException("Step index must be >= 0: " + iStepIndex);
        }
        if (!this.isRightClosed()) {
            ++iStepIndex;
        }
        Object value = ((ISequenceable)this.getRightEndpoint()).previousNthInSequence(this.getStep(), this.getUnit(), iStepIndex);
        int iComp = value.compareTo((ISequenceable)((ISequenceable)this.getLeftEndpoint()));
        if (this.isLeftClosed() ? iComp >= 0 : iComp > 0) {
            return value;
        }
        return null;
    }

    private class ReverseSequenceableIterator
    implements Iterator<E> {
        private E _csr;

        public ReverseSequenceableIterator() {
            this._csr = (ISequenceable)SequenceableInterval.this.getRightEndpoint();
            if (!SequenceableInterval.this.isRightClosed() && this.hasNext()) {
                this.next();
            }
        }

        @Override
        public boolean hasNext() {
            if (this._csr == null) {
                return false;
            }
            int iComp = this._csr.compareTo((ISequenceable)((ISequenceable)SequenceableInterval.this.getLeftEndpoint()));
            return iComp > 0 || SequenceableInterval.this.isLeftClosed() && iComp == 0;
        }

        @Override
        public E next() {
            int iComp = this._csr.compareTo((ISequenceable)((ISequenceable)SequenceableInterval.this.getLeftEndpoint()));
            if (iComp < 0 || !SequenceableInterval.this.isLeftClosed() && iComp == 0) {
                throw new NoSuchElementException();
            }
            Object ret = this._csr;
            this._csr = this._csr.previousInSequence(SequenceableInterval.this.getStep(), SequenceableInterval.this.getUnit());
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class SequenceableIterator
    implements Iterator<E> {
        private E _csr;

        public SequenceableIterator() {
            this._csr = (ISequenceable)SequenceableInterval.this.getLeftEndpoint();
            if (!SequenceableInterval.this.isLeftClosed() && this.hasNext()) {
                this.next();
            }
        }

        @Override
        public boolean hasNext() {
            if (this._csr == null) {
                return false;
            }
            int iComp = this._csr.compareTo((ISequenceable)((ISequenceable)SequenceableInterval.this.getRightEndpoint()));
            return iComp < 0 || SequenceableInterval.this.isRightClosed() && iComp == 0;
        }

        @Override
        public E next() {
            int iComp = this._csr.compareTo((ISequenceable)((ISequenceable)SequenceableInterval.this.getRightEndpoint()));
            if (iComp > 0 || !SequenceableInterval.this.isRightClosed() && iComp == 0) {
                throw new NoSuchElementException();
            }
            Object ret = this._csr;
            this._csr = this._csr.nextInSequence(SequenceableInterval.this.getStep(), SequenceableInterval.this.getUnit());
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

