/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.gosuc;

import gw.lang.gosuc.GosucProjectParser;
import gw.lang.parser.IToken;
import java.util.ArrayList;
import java.util.List;

public class GosucSdk {
    private List<String> _paths;
    private List<String> _backingSource;

    public GosucSdk(List<String> paths, List<String> backingSource) {
        this._paths = paths;
        this._backingSource = backingSource;
    }

    public List<String> getPaths() {
        return this._paths;
    }

    public List<String> getBackingSourcePath() {
        return this._backingSource;
    }

    public String write() {
        StringBuilder sb = new StringBuilder().append("sdk {\n");
        for (String path : this.getPaths()) {
            sb.append("  ").append("\"").append(path).append("\",\n");
        }
        sb.append("}\n").append("backingsource {\n");
        for (String path : this.getBackingSourcePath()) {
            sb.append("  ").append("\"").append(path).append("\",\n");
        }
        sb.append("}");
        return sb.toString();
    }

    public static GosucSdk parse(GosucProjectParser parser) {
        parser.verify(parser.matchWord("sdk", false), "Expecting 'sdk' keyword");
        parser.verify(parser.match(null, 123, false), "Expecting '{' to begin sdk path list");
        ArrayList<String> paths = new ArrayList<String>();
        IToken t = parser.getTokenizer().getCurrentToken();
        while (parser.match(null, 34, false)) {
            paths.add(t.getStringValue());
            if (!parser.match(null, 44, false)) break;
            t = parser.getTokenizer().getCurrentToken();
        }
        parser.verify(parser.match(null, 125, false), "Expecting '}' to close sdk path list");
        ArrayList<String> backingSource = new ArrayList<String>();
        if (parser.matchWord("backingsource", false)) {
            parser.verify(parser.match(null, 123, false), "Expecting '{' to begin backingsource path list");
            IToken t2 = parser.getTokenizer().getCurrentToken();
            while (parser.match(null, 34, false)) {
                paths.add(t2.getStringValue());
                if (!parser.match(null, 44, false)) break;
                t2 = parser.getTokenizer().getCurrentToken();
            }
            parser.verify(parser.match(null, 125, false), "Expecting '}' to close sdk path list");
        }
        return new GosucSdk(paths, backingSource);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GosucSdk gosucSdk = (GosucSdk)o;
        if (!this._backingSource.equals(gosucSdk._backingSource)) {
            return false;
        }
        return this._paths.equals(gosucSdk._paths);
    }

    public int hashCode() {
        int result = this._paths.hashCode();
        result = 31 * result + this._backingSource.hashCode();
        return result;
    }
}

