/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.ir.statement;

import gw.lang.UnstableAPI;
import gw.lang.ir.IRStatement;
import gw.lang.ir.statement.IRBreakStatement;
import gw.lang.ir.statement.IRCaseClause;
import gw.lang.ir.statement.IRContinueStatement;
import gw.lang.ir.statement.IRTerminalStatement;
import java.util.List;

@UnstableAPI
public class IRSwitchStatement
extends IRStatement {
    private final boolean _areLabelsConstant;
    private IRStatement _init;
    private List<IRCaseClause> _cases;
    private List<IRStatement> _defaultStatements;

    public IRSwitchStatement(IRStatement init, List<IRCaseClause> cases, List<IRStatement> defaultStatements, boolean areLabelsConstant) {
        this._init = init;
        this._cases = cases;
        this._defaultStatements = defaultStatements;
        this._areLabelsConstant = areLabelsConstant;
        this.setParentToThis(init);
        for (IRCaseClause caseClause : cases) {
            this.setParentToThis(caseClause.getCondition());
            for (IRStatement caseStatement : caseClause.getStatements()) {
                this.setParentToThis(caseStatement);
            }
        }
        for (IRStatement defaultStatement : defaultStatements) {
            this.setParentToThis(defaultStatement);
        }
    }

    public IRStatement getInit() {
        return this._init;
    }

    public boolean areLabelsConstant() {
        return this._areLabelsConstant;
    }

    public List<IRCaseClause> getCases() {
        return this._cases;
    }

    public List<IRStatement> getDefaultStatements() {
        return this._defaultStatements;
    }

    @Override
    public IRTerminalStatement getLeastSignificantTerminalStatement() {
        int i;
        if (this._defaultStatements.isEmpty()) {
            return null;
        }
        IRTerminalStatement caseStmtContinue = null;
        if (this._cases != null) {
            block0: for (i = 0; i < this._cases.size(); ++i) {
                List<IRStatement> caseStatements = this._cases.get(i).getStatements();
                if (caseStatements == null || caseStatements.size() <= 0) continue;
                for (int iStmt = 0; iStmt < caseStatements.size(); ++iStmt) {
                    IRTerminalStatement terminalStmt;
                    IRStatement statement = caseStatements.get(iStmt);
                    IRTerminalStatement iRTerminalStatement = terminalStmt = statement == null ? null : statement.getLeastSignificantTerminalStatement();
                    if (terminalStmt == null || terminalStmt instanceof IRBreakStatement) continue;
                    if (!(terminalStmt instanceof IRContinueStatement)) continue block0;
                    caseStmtContinue = (IRContinueStatement)terminalStmt;
                    continue block0;
                }
                return null;
            }
        }
        for (i = 0; i < this._defaultStatements.size(); ++i) {
            IRTerminalStatement terminalStmt = this._defaultStatements.get(i).getLeastSignificantTerminalStatement();
            if (terminalStmt == null || terminalStmt instanceof IRBreakStatement) continue;
            return caseStmtContinue != null ? caseStmtContinue : terminalStmt;
        }
        return null;
    }
}

