/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.parser;

import gw.lang.parser.IExpression;
import gw.lang.parser.IParseResult;
import gw.lang.parser.IParsedElement;
import gw.lang.parser.IStatement;
import gw.lang.parser.expressions.ILiteralExpression;
import gw.lang.parser.expressions.IProgram;
import gw.lang.reflect.IType;
import gw.lang.reflect.gs.IGosuProgram;

public final class ParseResult
implements IParseResult {
    private IExpression _expr;
    private IGosuProgram _program;

    public ParseResult() {
    }

    public ParseResult(IExpression expr) {
        this._expr = expr;
    }

    public ParseResult(IGosuProgram program) {
        this._program = program;
    }

    @Override
    public IExpression getExpression() {
        return this._expr == null ? this._program.getExpression() : this._expr;
    }

    @Override
    public IStatement getStatement() {
        return this._expr instanceof IProgram ? ((IProgram)this._expr).getMainStatement() : (this._program != null ? this._program.getStatement() : null);
    }

    @Override
    public IParsedElement getParsedElement() {
        if (this._expr != null) {
            return this._expr;
        }
        if (this._program != null) {
            if (this._program.getExpression() != null) {
                return this._program.getExpression();
            }
            if (this._program.getStatement() != null) {
                return this._program.getStatement();
            }
        }
        return null;
    }

    @Override
    public IExpression getRawExpression() {
        return this._expr;
    }

    @Override
    public IGosuProgram getProgram() {
        return this._program;
    }

    @Override
    public boolean isLiteral() {
        return this.getExpression() instanceof ILiteralExpression;
    }

    @Override
    public boolean isProgram() {
        return this._expr instanceof IProgram || this.getStatement() != null;
    }

    @Override
    public IType getType() {
        if (this._expr != null) {
            if (this._expr.getType() != null) {
                return this._expr.getType();
            }
            if (this._expr instanceof IProgram) {
                return this._expr.getReturnType();
            }
            return null;
        }
        return this._program.getReturnType();
    }

    @Override
    public Object evaluate() {
        return this._program != null ? this._program.evaluate(null) : this._expr.evaluate();
    }
}

