/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.reflect;

import gw.fs.IDirectory;
import gw.fs.IFile;
import gw.lang.reflect.RefreshKind;
import gw.lang.reflect.TypeLoaderBase;
import gw.lang.reflect.module.IModule;
import java.util.List;
import java.util.Set;

public abstract class SimpleTypeLoader
extends TypeLoaderBase {
    protected SimpleTypeLoader(IModule module) {
        super(module);
    }

    public abstract Set<String> getExtensions();

    @Override
    public boolean handlesFile(IFile file) {
        return this.getExtensions().contains(file.getExtension());
    }

    @Override
    public String[] getTypesForFile(IFile file) {
        List<IDirectory> sourcePath = this.getModule().getSourcePath();
        for (IDirectory src : sourcePath) {
            if (!file.isDescendantOf(src)) continue;
            String fqn = src.relativePath(file);
            fqn = fqn.substring(0, fqn.lastIndexOf(46)).replace('/', '.');
            return new String[]{fqn};
        }
        return new String[0];
    }

    @Override
    public RefreshKind refreshedFile(IFile file, String[] types, RefreshKind kind) {
        return kind;
    }

    @Override
    public boolean handlesDirectory(IDirectory dir) {
        List<IDirectory> sourcePath = this.getModule().getSourcePath();
        for (IDirectory src : sourcePath) {
            if (!dir.isDescendantOf(src)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getNamespaceForDirectory(IDirectory dir) {
        List<IDirectory> sourcePath = this.getModule().getSourcePath();
        for (IDirectory src : sourcePath) {
            if (!dir.isDescendantOf(src)) continue;
            return src.relativePath(dir).replace('/', '.');
        }
        return null;
    }
}

