/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.reflect.java.asm;

import gw.lang.reflect.java.asm.AsmUtil;
import gw.lang.reflect.java.asm.IAsmType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AsmType
implements IAsmType {
    private String _name;
    protected List<AsmType> _typeParameters;
    private int _iArrayDims;
    private boolean _bTypeVariable;
    private boolean _bFunctionTypeVar;

    AsmType(String normalDotName) {
        this._name = AsmUtil.makeBaseName(normalDotName);
        this.verifyNoArrayBrackets();
        this._typeParameters = Collections.emptyList();
    }

    AsmType(String normalDotName, int iDims) {
        this._name = normalDotName;
        this.verifyNoArrayBrackets();
        this._iArrayDims = iDims;
        this._typeParameters = Collections.emptyList();
    }

    private AsmType() {
    }

    AsmType copy() {
        AsmType copy = new AsmType();
        copy._name = this._name;
        copy._typeParameters = this._typeParameters.isEmpty() ? Collections.emptyList() : new ArrayList<AsmType>(this._typeParameters);
        copy._iArrayDims = this._iArrayDims;
        copy._bTypeVariable = this._bTypeVariable;
        copy._bFunctionTypeVar = this._bFunctionTypeVar;
        return copy;
    }

    AsmType copyNoArrayOrParameters() {
        AsmType copy = new AsmType();
        copy._name = this._name;
        copy._typeParameters = Collections.emptyList();
        copy._iArrayDims = 0;
        copy._bTypeVariable = this._bTypeVariable;
        copy._bFunctionTypeVar = this._bFunctionTypeVar;
        return copy;
    }

    @Override
    public AsmType getRawType() {
        AsmType copy = new AsmType();
        copy._name = this._name;
        copy._iArrayDims = this._iArrayDims;
        copy._typeParameters = Collections.emptyList();
        return copy;
    }

    @Override
    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this.verifyNoArrayBrackets();
        this._name = name;
    }

    public String getNameWithArrayBrackets() {
        Object name = this.getName();
        for (int i = 0; i < this._iArrayDims; ++i) {
            name = (String)name + "[]";
        }
        return name;
    }

    @Override
    public String getSimpleName() {
        String name = this.getName();
        int iDot = name.lastIndexOf(46);
        if (iDot < 0) {
            return name;
        }
        return name.substring(iDot + 1);
    }

    @Override
    public List<AsmType> getTypeParameters() {
        return this._typeParameters;
    }

    public void addTypeParameter(AsmType type) {
        if (this._typeParameters.isEmpty()) {
            this._typeParameters = new ArrayList<AsmType>(2);
        }
        this._typeParameters.add(type);
    }

    @Override
    public boolean isParameterized() {
        return !this._typeParameters.isEmpty();
    }

    @Override
    public boolean isArray() {
        return this._iArrayDims > 0;
    }

    @Override
    public AsmType getComponentType() {
        if (this.isArray()) {
            AsmType copy = this.copy();
            --copy._iArrayDims;
            if (copy._iArrayDims < 0) {
                throw new IllegalStateException();
            }
            return copy;
        }
        return null;
    }

    @Override
    public boolean isTypeVariable() {
        return this._bTypeVariable;
    }

    void setTypeVariable() {
        this._bTypeVariable = true;
    }

    public void setFunctionTypeVariable(boolean bFunctionTypeVariable) {
        this._bFunctionTypeVar = bFunctionTypeVariable;
    }

    public boolean isFunctionTypeVariable() {
        return this._bFunctionTypeVar;
    }

    public void incArrayDims() {
        ++this._iArrayDims;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public String getFqn() {
        int i;
        Object name = this.getName();
        if (!this.getTypeParameters().isEmpty()) {
            name = (String)name + "<";
            for (i = 0; i < this.getTypeParameters().size(); ++i) {
                if (i > 0) {
                    name = (String)name + ", ";
                }
                name = (String)name + this.getTypeParameters().get(i).toString();
            }
            name = (String)name + ">";
        }
        for (i = 0; i < this._iArrayDims; ++i) {
            name = (String)name + "[]";
        }
        return name;
    }

    public String toString() {
        return this.getFqn();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AsmType)) {
            return false;
        }
        AsmType asmType = (AsmType)o;
        if (this._bTypeVariable != asmType._bTypeVariable) {
            return false;
        }
        if (this._bFunctionTypeVar != asmType._bFunctionTypeVar) {
            return false;
        }
        if (this._iArrayDims != asmType._iArrayDims) {
            return false;
        }
        if (!this._name.equals(asmType._name)) {
            return false;
        }
        return this._typeParameters.equals(asmType._typeParameters);
    }

    public int hashCode() {
        int result = this._name.hashCode();
        result = 31 * result + this._typeParameters.hashCode();
        result = 31 * result + this._iArrayDims;
        result = 31 * result + (this._bTypeVariable ? 1 : 0);
        result = 31 * result + (this._bFunctionTypeVar ? 1 : 0);
        return result;
    }

    private void verifyNoArrayBrackets() {
        if (this._name.indexOf(91) >= 0) {
            throw new IllegalArgumentException("Name must not contain array brackets");
        }
    }
}

