/*
 * Decompiled with CFR 0.152.
 */
package gw.util.perf.objectsize;

import java.text.DecimalFormat;

public class ObjectSize {
    private long length;
    private boolean complete;
    private static String[] units = new String[]{"b", "Kb", "Mb", "Gb", "Tb"};
    private static DecimalFormat format = new DecimalFormat("#.#");

    public ObjectSize(long length, boolean complete) {
        this.length = length;
        this.complete = complete;
    }

    public String toString() {
        return ObjectSize.toString(this.length) + " (" + (this.complete ? "complete" : "incomplete") + ")";
    }

    public static String toString(double value) {
        int unit = 0;
        while (value >= 1024.0) {
            value /= 1024.0;
            ++unit;
        }
        return format.format(value) + " " + units[unit];
    }

    public void add(ObjectSize size) {
        this.length += size.length;
        this.complete &= size.complete;
    }

    public boolean isIncomplete() {
        return !this.complete;
    }

    public long size() {
        return this.length;
    }
}

