/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.reflect.gs;

import gw.lang.parser.ISource;
import gw.lang.parser.StringSource;
import gw.lang.reflect.gs.ClassType;
import gw.lang.reflect.gs.StringSourceFileHandle;
import java.util.concurrent.Callable;
import java.util.function.Function;

public class LazyStringSourceFileHandle
extends StringSourceFileHandle {
    private Function<Boolean, String> _sourceGen;
    private String _namespace;

    public LazyStringSourceFileHandle(String nspace, String fqn, Callable<String> sourceGen, ClassType classType) {
        this(nspace, fqn, (Boolean __) -> {
            try {
                return (String)sourceGen.call();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }, classType);
    }

    public LazyStringSourceFileHandle(String nspace, String fqn, Function<Boolean, String> sourceGen, ClassType classType) {
        super(fqn, null, false, classType);
        this._namespace = nspace;
        this._sourceGen = sourceGen;
    }

    @Override
    public String getTypeNamespace() {
        return this._namespace;
    }

    @Override
    public ISource getSource() {
        if (this.getRawSource() == null) {
            try {
                this.setRawSource(this._sourceGen.apply(false));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return super.getSource();
    }

    @Override
    public ISource getSource(boolean header) {
        return header ? new StringSource(this._sourceGen.apply(header)) : this.getSource();
    }
}

