/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.reflect.module;

import gw.fs.IDirectory;
import gw.lang.UnstableAPI;
import gw.lang.reflect.gs.TypeName;
import java.util.ArrayList;
import java.util.Set;

@UnstableAPI
public interface IClassPath {
    public static final String GW_API_PREFIX = "gw.";
    public static final String GW_INTERNAL_PREFIX = "gw.internal.";
    public static final String SUN_CLASS_PREFIX = "sun.";
    public static final String COM_SUN_CLASS_PREFIX = "com.sun.";
    public static final String PLACEHOLDER_FOR_PACKAGE = "PLACEHOLDER";
    public static final ClassPathFilter ALLOW_ALL_FILTER = new ClassPathFilter(){

        @Override
        public boolean acceptClass(String className) {
            return true;
        }

        @Override
        public boolean isIgnoreAnonymous() {
            return false;
        }
    };
    public static final ClassPathFilter ONLY_API_CLASSES = new ClassPathFilter(){

        @Override
        public boolean acceptClass(String className) {
            return className.startsWith(IClassPath.GW_API_PREFIX) && !className.startsWith(IClassPath.GW_INTERNAL_PREFIX);
        }

        @Override
        public boolean isIgnoreAnonymous() {
            return true;
        }
    };
    public static final ClassPathFilter ALLOW_ALL_WITH_SUN_FILTER = new ClassPathFilter(){

        @Override
        public boolean acceptClass(String className) {
            return true;
        }

        @Override
        public boolean isIgnoreAnonymous() {
            return true;
        }
    };

    public ArrayList<IDirectory> getPaths();

    public Set<String> getFilteredClassNames();

    public Set<TypeName> getTypeNames(String var1);

    public static interface ClassPathFilter {
        public boolean acceptClass(String var1);

        public boolean isIgnoreAnonymous();
    }
}

