/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.reflect.json;

import gw.lang.reflect.json.IJsonParentType;
import gw.lang.reflect.json.IJsonType;
import gw.lang.reflect.json.Json;
import java.util.HashMap;
import java.util.Map;

class JsonListType
implements IJsonParentType {
    private IJsonType _componentType;
    private IJsonParentType _parent;
    private Map<String, IJsonParentType> _innerTypes;

    JsonListType(IJsonParentType parent) {
        this._parent = parent;
        this._innerTypes = new HashMap<String, IJsonParentType>();
    }

    @Override
    public String getName() {
        return "List<" + this._componentType.getName() + ">";
    }

    @Override
    public IJsonParentType getParent() {
        return this._parent;
    }

    @Override
    public void addChild(String name, IJsonParentType type) {
        this._innerTypes.put(name, type);
    }

    @Override
    public IJsonParentType findChild(String name) {
        return this._innerTypes.get(name);
    }

    public IJsonType getComponentType() {
        return this._componentType;
    }

    public void setComponentType(IJsonType compType) {
        if (this._componentType != null && this._componentType != compType) {
            throw new IllegalStateException("Component type already set to: " + this._componentType.getName() + ", which is not the same as: " + compType.getName());
        }
        this._componentType = compType;
    }

    public IJsonType merge(JsonListType other) {
        JsonListType mergedType = new JsonListType(this.getParent());
        if (!this.getComponentType().equals(other.getComponentType())) {
            IJsonType componentType = Json.mergeTypes(this.getComponentType(), other.getComponentType());
            if (componentType != null) {
                mergedType.setComponentType(componentType);
            } else {
                return null;
            }
        }
        for (Map.Entry<String, IJsonParentType> e : this._innerTypes.entrySet()) {
            String name = e.getKey();
            IJsonType innerType = other.findChild(name);
            innerType = innerType != null ? Json.mergeTypes(e.getValue(), innerType) : (IJsonType)e.getValue();
            if (innerType != null) {
                mergedType.addChild(name, (IJsonParentType)innerType);
                continue;
            }
            return null;
        }
        return mergedType;
    }

    @Override
    public void render(StringBuilder sb, int indent, boolean mutable) {
        for (IJsonParentType child : this._innerTypes.values()) {
            child.render(sb, indent, mutable);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonListType that = (JsonListType)o;
        if (!this._componentType.equals(that._componentType)) {
            return false;
        }
        return this._innerTypes.equals(that._innerTypes);
    }

    public int hashCode() {
        int result = this._componentType.hashCode();
        result = 31 * result + this._innerTypes.hashCode();
        return result;
    }
}

