/*
 * Decompiled with CFR 0.152.
 */
package gw.config;

import gw.config.CommonServices;
import java.lang.management.ManagementFactory;

public enum ExecutionMode {
    RUNTIME(ManagementFactory.getRuntimeMXBean().getInputArguments().toString().contains("jdwp")),
    IDE(true),
    COMPILER(false);

    private static ExecutionMode _mode;
    private boolean _bSupportsRefresh;

    private ExecutionMode(boolean bSupportsRefresh) {
        this._bSupportsRefresh = this.checkCommandLineOverride(bSupportsRefresh);
    }

    private boolean checkCommandLineOverride(boolean bDefault) {
        String refreshProperty = System.getProperty("gosu.refresh");
        if (refreshProperty != null) {
            return Boolean.valueOf(refreshProperty);
        }
        return bDefault;
    }

    public boolean isRefreshSupportEnabled() {
        return this._bSupportsRefresh;
    }

    public static ExecutionMode get() {
        return _mode == null ? (_mode = CommonServices.getPlatformHelper().getExecutionMode()) : _mode;
    }

    public static void clear() {
        _mode = null;
    }

    public static boolean isRuntime() {
        return ExecutionMode.get() == RUNTIME;
    }

    public static boolean isIDE() {
        return ExecutionMode.get() == IDE;
    }

    public static boolean isCompiler() {
        return ExecutionMode.get() == COMPILER;
    }
}

