/*
 * Decompiled with CFR 0.152.
 */
package gw.fs;

import gw.lang.UnstableAPI;
import gw.util.DynamicArray;
import gw.util.GosuObjectUtil;
import gw.util.GosuStringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

@UnstableAPI
public class ResourcePath {
    public static final String WINDOWS_NETWORK_ROOT = "\\\\";
    protected final ResourcePath _parent;
    protected final String _name;

    protected ResourcePath(ResourcePath parent, String name) {
        if (name == null) {
            throw new IllegalArgumentException("The name argument to the ResourcePath constructor cannot be null");
        }
        this._parent = parent;
        this._name = name;
    }

    public static ResourcePath parse(String pathString) {
        int lastIndex;
        Object rootElement;
        if (pathString.startsWith(WINDOWS_NETWORK_ROOT)) {
            rootElement = WINDOWS_NETWORK_ROOT;
            lastIndex = 2;
        } else if (pathString.startsWith("/")) {
            rootElement = "";
            lastIndex = 1;
        } else {
            char first = pathString.charAt(0);
            if (pathString.length() > 1 && pathString.charAt(1) == ':' && Character.isLetter(first)) {
                rootElement = Character.toUpperCase(first) + ":";
                lastIndex = 2;
                if (pathString.length() > 2 && (pathString.charAt(2) == '/' || pathString.charAt(2) == '\\')) {
                    lastIndex = 3;
                }
            } else {
                throw new IllegalArgumentException("The path string [" + pathString + "] is not an absolute path starting at a drive root");
            }
        }
        DynamicArray<String> results = ResourcePath.tokenizePathFragment(pathString, lastIndex);
        results = ResourcePath.normalizePath(results);
        return ResourcePath.construct((String)rootElement, results, results.size() - 1);
    }

    private static DynamicArray<String> tokenizePathFragment(String pathString, int lastIndex) {
        DynamicArray<String> results = new DynamicArray<String>();
        for (int i = lastIndex; i < pathString.length(); ++i) {
            char c = pathString.charAt(i);
            if (c != '/' && c != '\\') continue;
            results.add(pathString.substring(lastIndex, i));
            lastIndex = i + 1;
        }
        pathString = pathString.substring(lastIndex);
        results.add(pathString);
        return results;
    }

    private static DynamicArray<String> normalizePath(DynamicArray<String> pathElements) {
        DynamicArray<String> results = new DynamicArray<String>(pathElements.size());
        for (int i = 0; i < pathElements.size; ++i) {
            String s = (String)pathElements.data[i];
            if (s.equals(".") || s.equals("/") || s.equals("\\") || s.equals("")) continue;
            if (s.equals("..")) {
                results.remove(results.size() - 1);
                continue;
            }
            results.add(s);
        }
        return results;
    }

    private static ResourcePath construct(String headElement, List<String> fullPath, int nameIndex) {
        if (nameIndex == -1) {
            if (headElement == null) {
                return null;
            }
            return new ResourcePathHead(headElement);
        }
        return new ResourcePath(ResourcePath.construct(headElement, fullPath, nameIndex - 1), fullPath.get(nameIndex));
    }

    public String getName() {
        return this._name;
    }

    public ResourcePath getParent() {
        return this._parent;
    }

    public String getPathString() {
        return this.getPathString("/");
    }

    public String getFileSystemPathString() {
        return this.getPathString(File.separator);
    }

    public String getPathString(String separator) {
        StringBuilder sb = new StringBuilder();
        this.constructPathString(sb, separator);
        return sb.toString();
    }

    private void constructPathString(StringBuilder sb, String separator) {
        if (this._parent != null) {
            this._parent.constructPathString(sb, separator);
            if (!(this._parent instanceof ResourcePathHead) || !this._parent.getName().equals(WINDOWS_NETWORK_ROOT)) {
                sb.append(separator);
            }
        }
        sb.append(this._name);
    }

    public ResourcePath join(String otherPath) {
        if (otherPath == null) {
            throw new IllegalArgumentException("The join(String) method cannot be called with a null argument");
        }
        DynamicArray<String> components = ResourcePath.tokenizePathFragment(otherPath, 0);
        ResourcePath result = this;
        for (int i = 0; i < components.size; ++i) {
            String s = (String)components.data[i];
            if (s.equals(".") || s.equals("/") || s.equals("\\") || s.equals("")) continue;
            if (s.equals("..")) {
                if ((result = result.getParent()) != null) continue;
                throw new IllegalArgumentException("Joining the path [" + otherPath + "] to the base path [" + this.getPathString() + "] resulted in traversing backwards past the root path element");
            }
            result = new ResourcePath(result, s);
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ResourcePath) {
            ResourcePath otherPath = (ResourcePath)obj;
            return otherPath.getName().equals(this.getName()) && GosuObjectUtil.equals(this.getParent(), otherPath.getParent());
        }
        return false;
    }

    public int hashCode() {
        int result = this._parent != null ? this._parent.hashCode() : 0;
        result = 31 * result + (this._name != null ? this._name.hashCode() : 0);
        return result;
    }

    public boolean isChild(ResourcePath path) {
        return GosuObjectUtil.equals(this, path.getParent());
    }

    public boolean isDescendant(ResourcePath path) {
        for (ResourcePath pathToTest = path; pathToTest != null; pathToTest = pathToTest.getParent()) {
            if (!pathToTest.equals(this)) continue;
            return true;
        }
        return false;
    }

    public String relativePath(ResourcePath other) {
        return this.relativePath(other, File.separator);
    }

    public String relativePath(ResourcePath other, String separator) {
        ArrayList<String> pathComponents = new ArrayList<String>();
        boolean success = false;
        for (ResourcePath pathToTest = other; pathToTest != null; pathToTest = pathToTest.getParent()) {
            if (pathToTest.equals(this)) {
                success = true;
                break;
            }
            pathComponents.add(0, pathToTest.getName());
        }
        if (!success || pathComponents.isEmpty()) {
            return null;
        }
        return GosuStringUtil.join(pathComponents, separator);
    }

    private static class ResourcePathHead
    extends ResourcePath {
        protected ResourcePathHead(String name) {
            super(null, name);
        }

        @Override
        public String getPathString(String separator) {
            if (ResourcePath.WINDOWS_NETWORK_ROOT.equals(this._name)) {
                return this._name;
            }
            return this._name + separator;
        }
    }
}

