/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.gosuc;

import gw.fs.IDirectory;
import gw.fs.IFile;
import gw.lang.gosuc.GosucProject;
import gw.lang.parser.IParseIssue;
import gw.lang.parser.exceptions.ParseResultsException;
import gw.lang.parser.exceptions.ParseWarning;
import gw.lang.reflect.IAnnotationInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.IGosuClass;
import gw.lang.reflect.gs.ISourceFileHandle;
import gw.lang.reflect.module.IModule;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;

public class GosucCompiler {
    public List<IType> compile(GosucProject project, Collection<? extends CharSequence> typeNames) {
        ArrayList<IType> types = new ArrayList<IType>();
        if (!typeNames.isEmpty()) {
            if (typeNames.contains("-all")) {
                typeNames = project.getAllDefinedTypes();
            }
            for (CharSequence charSequence : typeNames) {
                System.out.println("Compiling " + String.valueOf(charSequence) + "...");
                IType type = TypeSystem.getByFullNameIfValid(charSequence.toString());
                if (type != null) {
                    if (!this.compileType(type)) continue;
                    types.add(type);
                    continue;
                }
                System.out.println(" - can't be compiled, name is invalid");
            }
        }
        return types;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean compileType(IType type) {
        if (!type.isCompilable()) {
            return false;
        }
        if (!(type instanceof IGosuClass)) {
            return false;
        }
        IModule module = type.getTypeLoader().getModule();
        if (module == TypeSystem.getJreModule()) {
            return false;
        }
        TypeSystem.pushModule(module);
        try {
            IGosuClass gsClass = (IGosuClass)type;
            boolean bValid = gsClass.isValid();
            ParseResultsException parseException = gsClass.getParseResultsException();
            if (parseException != null) {
                for (IParseIssue issue : parseException.getParseIssues()) {
                    System.out.println((issue instanceof ParseWarning ? "Warning: " : "Error: ") + issue.getConsoleMessage());
                }
            }
            if (bValid) {
                this.makeClassFileForOut((IGosuClass)type);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            TypeSystem.popModule(module);
        }
    }

    private File makeClassFileForOut(IGosuClass gsClass) {
        IModule module = TypeSystem.getCurrentModule();
        File[] classFile = new File[1];
        IDirectory moduleOutputDirectory = module.getOutputPath();
        if (moduleOutputDirectory == null) {
            throw new RuntimeException("Can't make class file, no output path for module " + module.getName());
        }
        String outRelativePath = gsClass.getName().replace('.', File.separatorChar) + ".class";
        try {
            File child = new File(moduleOutputDirectory.getPath().getFileSystemPathString());
            child.mkdirs();
            StringTokenizer tokenizer = new StringTokenizer(outRelativePath, File.separator + "/");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if ((child = new File(child, token)).exists()) continue;
                if (token.endsWith(".class")) {
                    child.createNewFile();
                    continue;
                }
                child.mkdir();
            }
            this.createClassFile(child, gsClass);
            this.maybeCopySourceFile(child.getParentFile(), gsClass);
            classFile[0] = child;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return classFile[0];
    }

    private void maybeCopySourceFile(File parent, IGosuClass gsClass) {
        File file;
        ISourceFileHandle sfh = gsClass.getSourceFileHandle();
        IFile srcFile = sfh.getFile();
        if (srcFile != null && (file = new File(srcFile.getPath().getFileSystemPathString())).isFile()) {
            try {
                GosucCompiler.copyFile(file, new File(parent, file.getName()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createClassFile(File outputFile, IGosuClass gosuClass) throws IOException {
        if (this.hasDoNotVerifyAnnotation(gosuClass)) {
            return;
        }
        byte[] bytes = TypeSystem.getGosuClassLoader().getBytes(gosuClass);
        try (FileOutputStream out = new FileOutputStream(outputFile);){
            ((OutputStream)out).write(bytes);
        }
        for (IGosuClass iGosuClass : gosuClass.getInnerClasses()) {
            String innerClassName = String.format("%s$%s.class", outputFile.getName().substring(0, outputFile.getName().lastIndexOf(46)), iGosuClass.getRelativeName());
            File innerClassFile = new File(outputFile.getParent(), innerClassName);
            if (innerClassFile.isFile()) {
                innerClassFile.createNewFile();
            }
            this.createClassFile(innerClassFile, iGosuClass);
        }
    }

    private boolean hasDoNotVerifyAnnotation(IGosuClass gsClass) {
        for (IAnnotationInfo ai : gsClass.getTypeInfo().getAnnotations()) {
            if (!ai.getType().getRelativeName().equals("DoNotVerifyResource")) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File sourceFile, File destFile) throws IOException {
        if (sourceFile.isDirectory()) {
            destFile.mkdirs();
            return;
        }
        if (!destFile.exists()) {
            destFile.getParentFile().mkdirs();
            destFile.createNewFile();
        }
        FileChannel source = null;
        AbstractInterruptibleChannel destination = null;
        try {
            source = new FileInputStream(sourceFile).getChannel();
            destination = new FileOutputStream(destFile).getChannel();
            ((FileChannel)destination).transferFrom(source, 0L, source.size());
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
    }
}

