/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.ir.builder;

import gw.lang.GosuShop;
import gw.lang.UnstableAPI;
import gw.lang.ir.IRType;
import gw.lang.ir.builder.IRExpressionBuilder;
import gw.lang.ir.builder.IRStatementBuilder;
import gw.lang.ir.builder.IRSymbolBuilder;
import gw.lang.ir.builder.IRTempSymbolBuilder;
import gw.lang.ir.builder.IRThisSymbolBuilder;
import gw.lang.ir.builder.expression.IRClassLiteralBuilder;
import gw.lang.ir.builder.expression.IRCompositeExpressionBuilder;
import gw.lang.ir.builder.expression.IRFieldGetExpressionBuilder;
import gw.lang.ir.builder.expression.IRIdentifierExpressionBuilder;
import gw.lang.ir.builder.expression.IRMethodCallExpressionBuilder;
import gw.lang.ir.builder.expression.IRNewArrayExpressionBuilder;
import gw.lang.ir.builder.expression.IRNewExpressionBuilder;
import gw.lang.ir.builder.expression.IRNullLiteralBuilder;
import gw.lang.ir.builder.expression.IRNumericLiteralBuilder;
import gw.lang.ir.builder.expression.IRStringLiteralBuilder;
import gw.lang.ir.builder.statement.IRArrayStoreStatementBuilder;
import gw.lang.ir.builder.statement.IRAssignmentStatementBuilder;
import gw.lang.ir.builder.statement.IRFieldSetStatementBuilder;
import gw.lang.ir.builder.statement.IRIfStatementBuilder;
import gw.lang.ir.builder.statement.IRReturnStatementBuilder;
import gw.lang.reflect.IType;
import gw.lang.reflect.java.IJavaClassConstructor;
import gw.lang.reflect.java.IJavaClassInfo;
import gw.lang.reflect.java.IJavaClassMethod;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@UnstableAPI
public class IRBuilderMethods {
    public static IRFieldGetExpressionBuilder field(String name) {
        return new IRFieldGetExpressionBuilder(IRBuilderMethods._this(), name);
    }

    public static IRIdentifierExpressionBuilder var(String name) {
        return new IRIdentifierExpressionBuilder(new IRSymbolBuilder(name));
    }

    public static IRIdentifierExpressionBuilder var(IRSymbolBuilder symbol) {
        return new IRIdentifierExpressionBuilder(symbol);
    }

    public static IRNumericLiteralBuilder literal(Number value) {
        return new IRNumericLiteralBuilder(value);
    }

    public static IRClassLiteralBuilder literal(Class cls) {
        return new IRClassLiteralBuilder(IRBuilderMethods.getIRType(cls));
    }

    public static IRExpressionBuilder literal(String value) {
        return new IRStringLiteralBuilder(value);
    }

    public static IRMethodCallExpressionBuilder call(String name, IRExpressionBuilder ... args) {
        return IRBuilderMethods.call((IRExpressionBuilder)IRBuilderMethods._this(), name, args);
    }

    public static IRMethodCallExpressionBuilder call(IJavaClassMethod method, IRExpressionBuilder ... args) {
        return IRBuilderMethods.call((IRExpressionBuilder)IRBuilderMethods._this(), method, args);
    }

    public static IRMethodCallExpressionBuilder callStatic(IJavaClassMethod method, IRExpressionBuilder ... args) {
        return IRBuilderMethods.call(null, method, args);
    }

    public static IRMethodCallExpressionBuilder call(IRExpressionBuilder root, String name, IRExpressionBuilder ... args) {
        return new IRMethodCallExpressionBuilder(root, name, Arrays.asList(args));
    }

    public static IRMethodCallExpressionBuilder call(IRExpressionBuilder root, IJavaClassMethod method, IRExpressionBuilder ... args) {
        return new IRMethodCallExpressionBuilder(root, method, Arrays.asList(args));
    }

    public static IRCompositeExpressionBuilder newArray(Class componentType, List<IRExpressionBuilder> values) {
        return IRBuilderMethods.newArray(IRBuilderMethods.getIRType(componentType), values);
    }

    public static IRCompositeExpressionBuilder newArray(IType componentType, List<IRExpressionBuilder> values) {
        return IRBuilderMethods.newArray(IRBuilderMethods.getIRType(componentType), values);
    }

    public static IRCompositeExpressionBuilder newArray(IJavaClassInfo componentType, List<IRExpressionBuilder> values) {
        return IRBuilderMethods.newArray(IRBuilderMethods.getIRType(componentType), values);
    }

    public static IRCompositeExpressionBuilder newArray(IRType componentType, List<IRExpressionBuilder> values) {
        ArrayList<IRStatementBuilder> statements = new ArrayList<IRStatementBuilder>();
        IRTempSymbolBuilder tempArray = new IRTempSymbolBuilder(componentType.getArrayType());
        statements.add(IRBuilderMethods.assign(tempArray, (IRExpressionBuilder)IRBuilderMethods.newArray(componentType, IRBuilderMethods.literal(values.size()))));
        for (int i = 0; i < values.size(); ++i) {
            statements.add(IRBuilderMethods.arrayStore(IRBuilderMethods.var(tempArray), IRBuilderMethods.literal(i), values.get(i)));
        }
        return new IRCompositeExpressionBuilder(statements, IRBuilderMethods.var(tempArray));
    }

    public static IRNewArrayExpressionBuilder newArray(Class rootType, int size) {
        return IRBuilderMethods.newArray(IRBuilderMethods.getIRType(rootType), IRBuilderMethods.literal(size));
    }

    public static IRNewArrayExpressionBuilder newArray(IType rootType, int size) {
        return IRBuilderMethods.newArray(IRBuilderMethods.getIRType(rootType), IRBuilderMethods.literal(size));
    }

    public static IRNewArrayExpressionBuilder newArray(IJavaClassInfo rootType, int size) {
        return IRBuilderMethods.newArray(IRBuilderMethods.getIRType(rootType), IRBuilderMethods.literal(size));
    }

    public static IRNewArrayExpressionBuilder newArray(IRType rootType, IRExpressionBuilder size) {
        return new IRNewArrayExpressionBuilder(rootType, size);
    }

    public static IRNewExpressionBuilder _new(Class rootType, IRExpressionBuilder ... values) {
        return new IRNewExpressionBuilder(IRBuilderMethods.getIRType(rootType), Arrays.asList(values));
    }

    public static IRNullLiteralBuilder _null() {
        return new IRNullLiteralBuilder();
    }

    public static List<IRExpressionBuilder> passArgs(IJavaClassMethod m) {
        ArrayList<IRExpressionBuilder> args = new ArrayList<IRExpressionBuilder>();
        IJavaClassInfo[] paramTypes = m.getParameterTypes();
        for (int i = 0; i < paramTypes.length; ++i) {
            args.add(IRBuilderMethods.var("arg" + i));
        }
        return args;
    }

    public static List<IRExpressionBuilder> passArgs(IJavaClassConstructor cons) {
        ArrayList<IRExpressionBuilder> args = new ArrayList<IRExpressionBuilder>();
        IJavaClassInfo[] paramTypes = cons.getParameterTypes();
        for (int i = 0; i < paramTypes.length; ++i) {
            args.add(IRBuilderMethods.var("arg" + i));
        }
        return args;
    }

    public static IRIdentifierExpressionBuilder _this() {
        return new IRIdentifierExpressionBuilder(new IRThisSymbolBuilder());
    }

    public static IRArrayStoreStatementBuilder arrayStore(IRExpressionBuilder target, IRExpressionBuilder index, IRExpressionBuilder value) {
        IRArrayStoreStatementBuilder statement = new IRArrayStoreStatementBuilder(target, index, value);
        return statement;
    }

    public static IRAssignmentStatementBuilder assign(String name, IRExpressionBuilder value) {
        return new IRAssignmentStatementBuilder(new IRSymbolBuilder(name), value);
    }

    public static IRAssignmentStatementBuilder assign(String name, IRType type, IRExpressionBuilder value) {
        return new IRAssignmentStatementBuilder(new IRSymbolBuilder(name, type), value);
    }

    public static IRAssignmentStatementBuilder assign(IRSymbolBuilder symbol, IRExpressionBuilder value) {
        return new IRAssignmentStatementBuilder(symbol, value);
    }

    public static IRIfStatementBuilder _if(IRExpressionBuilder test) {
        return new IRIfStatementBuilder(test);
    }

    public static IRReturnStatementBuilder _return() {
        return new IRReturnStatementBuilder();
    }

    public static IRReturnStatementBuilder _return(IRExpressionBuilder value) {
        return new IRReturnStatementBuilder(value);
    }

    public static IRFieldSetStatementBuilder set(String name, IRExpressionBuilder value) {
        return new IRFieldSetStatementBuilder(IRBuilderMethods._this(), name, value);
    }

    public static IRMethodCallExpressionBuilder _superInit(List<IRExpressionBuilder> args) {
        return IRMethodCallExpressionBuilder.callSuperInit(args);
    }

    public static IRMethodCallExpressionBuilder _superInit(IRExpressionBuilder ... args) {
        return IRMethodCallExpressionBuilder.callSuperInit(Arrays.asList(args));
    }

    public static IRType getIRType(Class cls) {
        return GosuShop.getIRTypeResolver().getDescriptor(cls);
    }

    public static IRType getIRType(IType type) {
        return GosuShop.getIRTypeResolver().getDescriptor(type);
    }

    public static IRType getIRType(IJavaClassInfo cls) {
        return GosuShop.getIRTypeResolver().getDescriptor(cls);
    }

    public static List<IRType> getIRTypes(Class[] classes) {
        ArrayList<IRType> results = new ArrayList<IRType>();
        for (Class cls : classes) {
            results.add(IRBuilderMethods.getIRType(cls));
        }
        return results;
    }
}

