/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.ir.builder;

import gw.lang.UnstableAPI;
import gw.lang.ir.IRStatement;
import gw.lang.ir.IRSymbol;
import gw.lang.ir.IRType;
import gw.lang.ir.builder.IRBuilderContext;
import gw.lang.ir.builder.IRClassBuilder;
import gw.lang.ir.builder.IRElementBuilder;
import gw.lang.ir.builder.IRFeatureBuilder;
import gw.lang.ir.builder.IRStatementBuilder;
import gw.lang.ir.builder.expression.IRMethodCallExpressionBuilder;
import gw.lang.ir.statement.IRMethodCallStatement;
import gw.lang.ir.statement.IRMethodStatement;
import gw.lang.ir.statement.IRStatementList;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.IParameterInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.java.IJavaClassConstructor;
import gw.lang.reflect.java.IJavaClassInfo;
import gw.lang.reflect.java.IJavaClassMethod;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@UnstableAPI
public class IRMethodBuilder
extends IRFeatureBuilder<IRMethodBuilder> {
    private IRClassBuilder _classBuilder;
    private String _name;
    private IRType _returnType;
    private List<IRSymbol> _parameters = new ArrayList<IRSymbol>();

    public IRMethodBuilder(IRClassBuilder classBuilder) {
        this._classBuilder = classBuilder;
    }

    public IRClassBuilder getClassBuilder() {
        return this._classBuilder;
    }

    public List<IRSymbol> getParameters() {
        return this._parameters;
    }

    public IRType getReturnType() {
        return this._returnType;
    }

    public IRMethodBuilder name(String name) {
        this._name = name;
        return this;
    }

    public IRMethodBuilder returns(IRType returnType) {
        this._returnType = returnType;
        return this;
    }

    public IRMethodBuilder returns(IType returnType) {
        return this.returns(this.getIRType(returnType));
    }

    public IRMethodBuilder returns(Class returnType) {
        return this.returns(this.getIRType(returnType));
    }

    public IRMethodBuilder returns(IJavaClassInfo returnType) {
        return this.returns(this.getIRType(returnType));
    }

    public IRMethodBuilder parameters(Object ... parameters) {
        if (parameters.length % 2 == 1) {
            throw new IllegalArgumentException("Parameters array must be an even number of arguments consisting of alternating names and types");
        }
        for (int i = 0; i < parameters.length; i += 2) {
            IRType type;
            String name = (String)parameters[i];
            Object typeObj = parameters[i + 1];
            if (typeObj instanceof Class) {
                type = this.getIRType((Class)typeObj);
            } else if (typeObj instanceof IType) {
                type = this.getIRType((IType)typeObj);
            } else if (typeObj instanceof IRType) {
                type = (IRType)typeObj;
            } else {
                throw new IllegalArgumentException("Argument " + String.valueOf(typeObj.getClass()) + " is not convertible to an IRType");
            }
            this.parameter(name, type);
        }
        return this;
    }

    public IRMethodBuilder copyParameters(IJavaClassMethod method) {
        IJavaClassInfo[] paramTypes = method.getParameterTypes();
        for (int i = 0; i < paramTypes.length; ++i) {
            this.parameter("arg" + i, this.getIRType(paramTypes[i]));
        }
        return this;
    }

    public IRMethodBuilder copyParameters(IMethodInfo method) {
        IParameterInfo[] paramTypes = method.getParameters();
        for (int i = 0; i < paramTypes.length; ++i) {
            this.parameter("arg" + i, this.getIRType(paramTypes[i].getFeatureType()));
        }
        return this;
    }

    public IRMethodBuilder copyParameters(Method method) {
        Class<?>[] paramTypes = method.getParameterTypes();
        for (int i = 0; i < paramTypes.length; ++i) {
            this.parameter("arg" + i, this.getIRType(paramTypes[i]));
        }
        return this;
    }

    public IRMethodBuilder copyParameters(IJavaClassConstructor cons) {
        IJavaClassInfo[] paramTypes = cons.getParameterTypes();
        for (int i = 0; i < paramTypes.length; ++i) {
            this.parameter("arg" + i, this.getIRType(paramTypes[i]));
        }
        return this;
    }

    public IRMethodBuilder copyParameters(Constructor cons) {
        Class<?>[] paramTypes = cons.getParameterTypes();
        for (int i = 0; i < paramTypes.length; ++i) {
            this.parameter("arg" + i, this.getIRType(paramTypes[i]));
        }
        return this;
    }

    public IRMethodBuilder parameter(String name, IRType type) {
        this._parameters.add(new IRSymbol(name, type, false));
        return this;
    }

    public IRMethodBuilder parameter(String name, Class cls) {
        return this.parameter(name, this.getIRType(cls));
    }

    public IRMethodBuilder parameter(String name, IType type) {
        return this.parameter(name, this.getIRType(type));
    }

    public IRMethodStatement body(IRElementBuilder ... elements) {
        return this.body(Arrays.asList(elements));
    }

    public IRMethodStatement body(List<IRElementBuilder> elements) {
        IRBuilderContext context = new IRBuilderContext(this);
        ArrayList<IRStatement> statements = new ArrayList<IRStatement>();
        for (IRElementBuilder element : elements) {
            if (element instanceof IRStatementBuilder) {
                statements.add(((IRStatementBuilder)element).build(context));
                continue;
            }
            if (element instanceof IRMethodCallExpressionBuilder) {
                statements.add(new IRMethodCallStatement(((IRMethodCallExpressionBuilder)element).build(context)));
                continue;
            }
            throw new IllegalArgumentException("Element " + String.valueOf(element.getClass()) + " is not a statement or method call");
        }
        return this.build(new IRStatementList(true, statements));
    }

    private IRMethodStatement build(IRStatement body) {
        IRMethodStatement method = new IRMethodStatement(body, this._name, this._modifiers, false, this._returnType, this._parameters);
        this._classBuilder.withMethod(method);
        return method;
    }
}

