/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.ir.expression;

import gw.lang.UnstableAPI;
import gw.lang.ir.IRExpression;
import gw.lang.ir.IRType;

@UnstableAPI
public class IRCastExpression
extends IRExpression {
    private IRExpression _root;
    private IRType _type;

    public IRCastExpression(IRExpression root, IRType type) {
        if (type == null) {
            throw new IllegalArgumentException("The type to cast to cannot be null");
        }
        if (type.isPrimitive()) {
            throw new IllegalArgumentException("Cannot perform a cast to a primitive type: " + type.getName());
        }
        type = this.isExternalEntityType(type = IRCastExpression.maybeEraseStructuralType(type)) ? root.getType() : type;
        this._root = root;
        this._type = type;
        root.setParent(this);
    }

    private boolean isExternalEntityType(IRType type) {
        String prefix = "com.guidewire.";
        if (type.getName().startsWith(prefix)) {
            return type.getName().substring(prefix.length() - 1).startsWith(".external.");
        }
        return false;
    }

    public IRExpression getRoot() {
        return this._root;
    }

    @Override
    public IRType getType() {
        return this._type;
    }
}

