/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.parser.exceptions;

import gw.lang.parser.IParserState;
import gw.lang.parser.ISymbolTable;
import gw.lang.parser.exceptions.ParseIssue;
import gw.lang.parser.expressions.IMemberAccessExpression;
import gw.lang.parser.resources.ResourceKey;
import gw.lang.reflect.IParameterInfo;
import gw.lang.reflect.IType;

public class ParseException
extends ParseIssue {
    private IType[] _paramTypesExpected;
    private IParameterInfo[][] _paramTypesPossible;
    private IType _typeExpected;
    private IMemberAccessExpression _memberAccessContext;
    private ParseException _alternateException;
    private boolean _bCausedByArgumentList;

    public ParseException(IParserState parserState, ResourceKey messageKey, Object ... args) {
        super(parserState, messageKey, args);
    }

    public ParseException(Integer lineNumber, Integer lineOffset, Integer tokenColumn, Integer tokenStart, Integer tokenEnd, ISymbolTable symbolTable, ResourceKey key, Object ... msgArgs) {
        super(lineNumber, lineOffset, tokenColumn, tokenStart, tokenEnd, symbolTable, key, msgArgs);
    }

    public ParseException(IParserState parserState, IType typeExpected, ResourceKey msgKey, Object ... args) {
        super(parserState, msgKey, args);
        this._typeExpected = typeExpected;
    }

    protected ParseException(ParseException e) {
        super(e.getLineNumber(), e.getLineOffset(), e.getTokenColumn(), e.getTokenStart(), e.getTokenEnd(), e.getSymbolTable(), e.getMessageKey(), e.getMessageArgs());
        this.setSource(e.getSource());
        try {
            this.setStateSource(e.getStateSource());
        }
        catch (Throwable t) {
            this.setStateSource("Error fetching source: " + String.valueOf(t));
        }
        this._paramTypesExpected = e._paramTypesExpected;
        this._paramTypesPossible = e._paramTypesPossible;
        this._typeExpected = e._typeExpected;
        this._memberAccessContext = e._memberAccessContext;
        this._alternateException = e._alternateException;
        this._bCausedByArgumentList = e._bCausedByArgumentList;
    }

    private ParseException(Throwable t, IParserState state) {
        super(state, t);
    }

    public static ParseException wrap(Throwable t, IParserState state) {
        if (t instanceof ParseException) {
            ParseException pe = (ParseException)t;
            return new ParseException(state, pe.getMessageKey(), pe.getMessageArgs());
        }
        return new ParseException(t, state);
    }

    public static ParseException shallowCopy(ParseException source) {
        ParseException copy = new ParseException(source.getLineNumber(), source.getLineOffset(), source.getTokenColumn(), source.getTokenStart(), source.getTokenEnd(), source.getSymbolTable(), source.getMessageKey(), source.getMessageArgs());
        copy._typeExpected = source._typeExpected;
        copy._paramTypesExpected = source._paramTypesExpected;
        copy._memberAccessContext = source._memberAccessContext;
        copy._alternateException = source._alternateException;
        copy._bCausedByArgumentList = source._bCausedByArgumentList;
        return copy;
    }

    @Override
    public String getConsoleMessage() {
        if (this._alternateException != null && this._alternateException != this) {
            return "\nThe script neither parsed as an expression nor as a program.\nExpression parse error:\n" + super.getConsoleMessage() + "\n\nProgram parse error:\n" + this._alternateException.getConsoleMessage() + "\n";
        }
        return super.getConsoleMessage();
    }

    @Override
    public IType getExpectedType() {
        return this._typeExpected;
    }

    @Override
    public void setExpectedType(IType typeExpected) {
        this._typeExpected = typeExpected;
    }

    public IType[] getParamTypesExpected() {
        return this._paramTypesExpected;
    }

    public void setParamTypesExpected(IType ... paramTypesExpected) {
        this._paramTypesExpected = paramTypesExpected;
    }

    public void setParamTypesPossible(IParameterInfo[][] paramTypesPossible) {
        this._paramTypesPossible = paramTypesPossible;
    }

    public IParameterInfo[][] getParamTypesPossible() {
        return this._paramTypesPossible;
    }

    @Override
    public String toString() {
        return this.getUIMessage();
    }

    public IMemberAccessExpression getMemberAccessContext() {
        return this._memberAccessContext;
    }

    public void setMemberAccessContext(IMemberAccessExpression ma) {
        this._memberAccessContext = ma;
    }

    public ParseException getAlternateException() {
        return this._alternateException;
    }

    public void setAlternateException(ParseException alternateException) {
        this._alternateException = alternateException;
    }

    public boolean isCausedByArgumentList() {
        return this._bCausedByArgumentList;
    }

    public void setCausedByArgumentList(boolean bCausedByArgumentList) {
        this._bCausedByArgumentList = bCausedByArgumentList;
    }
}

