/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.reflect;

import gw.lang.UnstableAPI;
import gw.lang.parser.ScriptabilityModifiers;
import gw.lang.reflect.IScriptabilityModifier;
import gw.lang.reflect.ScriptabilityModifierTypes;
import gw.lang.reflect.TypedParameterDescriptor;
import gw.lang.reflect.TypedPropertyDescriptor;
import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.MethodDescriptor;
import java.beans.ParameterDescriptor;

@UnstableAPI
public class BeanInfoUtil {
    public static final String SCRIPT_VISIBILITY_MODIFIERS = "_scriptVisibilityModifiers";
    protected static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    protected static final String[] EMPTY_STRING_ARRAY = new String[0];

    public static MethodDescriptor buildScriptableMethodDescriptorNoArgs(Class actionClass, String methodName) {
        MethodDescriptor md = BeanInfoUtil._buildMethodDescriptor(actionClass, methodName, EMPTY_STRING_ARRAY, EMPTY_CLASS_ARRAY, EMPTY_CLASS_ARRAY);
        BeanInfoUtil.makeScriptable(md);
        return md;
    }

    public static MethodDescriptor buildScriptableMethodDescriptor(Class actionClass, String methodName, String[] parameterNames, Class[] parameterTypes) {
        MethodDescriptor md = BeanInfoUtil._buildMethodDescriptor(actionClass, methodName, parameterNames, parameterTypes, parameterTypes);
        BeanInfoUtil.makeScriptable(md);
        return md;
    }

    public static MethodDescriptor buildScriptableDeprecatedMethodDescriptor(Class actionClass, String methodName, String[] parameterNames, Class[] parameterTypes) {
        MethodDescriptor md = BeanInfoUtil._buildMethodDescriptor(actionClass, methodName, parameterNames, parameterTypes, parameterTypes);
        BeanInfoUtil.makeScriptableDeprecated(md);
        return md;
    }

    public static MethodDescriptor buildHiddenMethodDescriptor(Class actionClass, String methodName, String[] parameterNames, Class[] parameterTypes) {
        MethodDescriptor md = BeanInfoUtil._buildMethodDescriptor(actionClass, methodName, parameterNames, parameterTypes, parameterTypes);
        md.setHidden(true);
        return md;
    }

    public static MethodDescriptor buildMethodDescriptor(Class actionClass, String methodName, String[] parameterNames, Class[] parameterTypes) {
        return BeanInfoUtil._buildMethodDescriptor(actionClass, methodName, parameterNames, parameterTypes, parameterTypes);
    }

    public static TypedPropertyDescriptor buildScriptablePropertyDescriptor(String propertyName, Class beanClass, String getterName, String setterName) {
        TypedPropertyDescriptor pd = BeanInfoUtil._buildPropertyDescriptor(propertyName, beanClass, getterName, setterName);
        BeanInfoUtil.makeScriptable(pd);
        return pd;
    }

    public static FeatureDescriptor makeScriptable(FeatureDescriptor descriptor) {
        BeanInfoUtil.setVisibilityModifier(descriptor, ScriptabilityModifiers.SCRIPTABLE);
        return descriptor;
    }

    public static FeatureDescriptor makeScriptableDeprecated(FeatureDescriptor descriptor) {
        BeanInfoUtil.setVisibilityModifier(descriptor, ScriptabilityModifiers.SCRIPTABLE_DEPRECATED);
        return descriptor;
    }

    public static boolean isScriptable(FeatureDescriptor descriptor) {
        return BeanInfoUtil.isVisible(descriptor, ScriptabilityModifiers.SCRIPTABLE);
    }

    public static boolean isDeprecated(FeatureDescriptor descriptor) {
        IScriptabilityModifier modifier = BeanInfoUtil.getVisibilityModifier(descriptor);
        if (modifier == null) {
            return false;
        }
        return modifier.hasModifierWithType(ScriptabilityModifierTypes.DEPRECATED);
    }

    public static boolean isVisible(FeatureDescriptor descriptor, IScriptabilityModifier constraint) {
        if (constraint == null) {
            return true;
        }
        IScriptabilityModifier modifier = BeanInfoUtil.getVisibilityModifier(descriptor);
        if (modifier == null) {
            return true;
        }
        return modifier.satisfiesConstraint(constraint);
    }

    public static IScriptabilityModifier getVisibilityModifier(FeatureDescriptor descriptor) {
        return (IScriptabilityModifier)descriptor.getValue(SCRIPT_VISIBILITY_MODIFIERS);
    }

    public static void setVisibilityModifier(FeatureDescriptor descriptor, IScriptabilityModifier modifier) {
        descriptor.setValue(SCRIPT_VISIBILITY_MODIFIERS, modifier);
    }

    protected static MethodDescriptor _buildMethodDescriptor(Class actionClass, String methodName, String[] parameterNames, Class[] parameterTypes, Class[] actualParameterTypes) {
        MethodDescriptor method;
        assert (parameterNames.length == parameterTypes.length) : "Number of parameter names different from number of parameter types.";
        assert (parameterNames.length == actualParameterTypes.length) : "Number of parameter names different from number of actual parameters.";
        try {
            int numParams = parameterNames.length;
            ParameterDescriptor[] parameters = new ParameterDescriptor[numParams];
            for (int i = 0; i < numParams; ++i) {
                parameters[i] = new TypedParameterDescriptor(parameterNames[i], parameterTypes[i]);
            }
            method = new MethodDescriptor(actionClass.getMethod(methodName, actualParameterTypes), parameters);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        return method;
    }

    protected static TypedPropertyDescriptor _buildPropertyDescriptor(String propertyName, Class beanClass, String getterName, String setterName) {
        try {
            return new TypedPropertyDescriptor(propertyName, beanClass, getterName, setterName);
        }
        catch (IntrospectionException e) {
            throw new RuntimeException("Failed to create property \"" + propertyName + "\" on class \"" + String.valueOf(beanClass) + "\": " + String.valueOf(e.getClass()) + " - " + e.getMessage());
        }
    }
}

