/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.reflect;

import gw.config.CommonServices;
import gw.lang.reflect.IAnnotationInfo;
import gw.lang.reflect.IFeatureInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.java.JavaTypes;
import gw.util.GosuObjectUtil;
import java.util.ArrayList;
import java.util.List;

public interface IAnnotatedFeatureInfo
extends IFeatureInfo {
    public static final IAnnotationInfoHelper ANNOTATION_HELPER = new IAnnotationInfoHelper();

    public List<IAnnotationInfo> getAnnotations();

    public List<IAnnotationInfo> getDeclaredAnnotations();

    public List<IAnnotationInfo> getAnnotationsOfType(IType var1);

    public IAnnotationInfo getAnnotation(IType var1);

    public boolean hasAnnotation(IType var1);

    public boolean hasDeclaredAnnotation(IType var1);

    public boolean isDeprecated();

    public String getDeprecatedReason();

    public boolean isDefaultImpl();

    public static class IAnnotationInfoHelper {
        private IAnnotationInfoHelper() {
        }

        public IAnnotationInfo getAnnotation(IType type, List<IAnnotationInfo> annotations, String featureName) {
            IAnnotationInfo result = null;
            for (IAnnotationInfo annotation : annotations) {
                if (!GosuObjectUtil.equals(annotation.getType(), type)) continue;
                if (result != null) {
                    throw new IllegalStateException("More than one instance of the annotation " + String.valueOf(type) + " exists!");
                }
                result = annotation;
            }
            return result;
        }

        public boolean hasAnnotation(IType type, List<IAnnotationInfo> annotations) {
            for (IAnnotationInfo annotation : annotations) {
                if (!GosuObjectUtil.equals(annotation.getType(), type)) continue;
                return true;
            }
            return false;
        }

        public List<IAnnotationInfo> getAnnotationsOfType(IType type, List<IAnnotationInfo> annotations) {
            ArrayList<IAnnotationInfo> result = new ArrayList<IAnnotationInfo>();
            for (IAnnotationInfo annotationInfo : annotations) {
                if (!type.equals(annotationInfo.getType())) continue;
                result.add(annotationInfo);
            }
            return result;
        }

        public boolean isInherited(IType type) {
            if (type == null) {
                return false;
            }
            return JavaTypes.IINHERITED().isAssignableFrom(type) || type.getTypeInfo().hasDeclaredAnnotation(JavaTypes.INHERITED());
        }

        public boolean shouldAddInheritedAnnotation(IFeatureInfo fi, List<IAnnotationInfo> annotations, IAnnotationInfo annotationInfo) {
            for (IAnnotationInfo annotation : annotations) {
                if (!annotation.getType().equals(annotationInfo.getType())) continue;
                return CommonServices.getGosuIndustrialPark().isAnnotationAllowedMultipleTimes(fi, annotationInfo);
            }
            return true;
        }
    }
}

