/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.reflect.interval;

import gw.lang.reflect.interval.IInterval;

public abstract class AbstractInterval<E extends Comparable<E>, ME extends AbstractInterval<E, ME>>
implements IInterval<E, ME> {
    private final E _left;
    private final E _right;
    private final boolean _bLeftClosed;
    private final boolean _bRightClosed;
    private final boolean _bReverse;

    public AbstractInterval(E left, E right) {
        this(left, right, true, true, false);
    }

    public AbstractInterval(E left, E right, boolean bLeftClosed, boolean bRightClosed, boolean bReverse) {
        this.checkArgs(left, right);
        this._left = left;
        this._right = right;
        this._bLeftClosed = bLeftClosed;
        this._bRightClosed = bRightClosed;
        this._bReverse = bReverse;
    }

    private void checkArgs(E left, E right) {
        if (left == null) {
            throw new IllegalArgumentException("Non-null value expected for left endpoint. Use BigIntegerInterval for an interval with an unbounded endpoint.");
        }
        if (right == null) {
            throw new IllegalArgumentException("Non-null value expected for right endpoint. Use BigIntegerInterval for an interval with an unbounded endpoint.");
        }
        if (left.compareTo(right) > 0) {
            throw new IllegalArgumentException("The left endpoint is greater than the right endpoint: [" + String.valueOf(left) + ", " + String.valueOf(right) + "]");
        }
    }

    @Override
    public E getLeftEndpoint() {
        return this._left;
    }

    @Override
    public E getRightEndpoint() {
        return this._right;
    }

    @Override
    public boolean isLeftClosed() {
        return this._bLeftClosed;
    }

    @Override
    public boolean isRightClosed() {
        return this._bRightClosed;
    }

    @Override
    public boolean contains(E e) {
        return (this.isLeftClosed() ? this.getLeftEndpoint().compareTo(e) <= 0 : this.getLeftEndpoint().compareTo(e) < 0) && (this.isRightClosed() ? this.getRightEndpoint().compareTo(e) >= 0 : this.getRightEndpoint().compareTo(e) > 0);
    }

    @Override
    public boolean contains(ME interval) {
        return (this.isLeftClosed() ? this.getLeftEndpoint().compareTo(((AbstractInterval)interval).getLeftEndpoint()) <= 0 : (((AbstractInterval)interval).isLeftClosed() ? this.getLeftEndpoint().compareTo(((AbstractInterval)interval).getLeftEndpoint()) < 0 : this.getLeftEndpoint().compareTo(((AbstractInterval)interval).getLeftEndpoint()) <= 0)) && (this.isRightClosed() ? this.getRightEndpoint().compareTo(((AbstractInterval)interval).getRightEndpoint()) >= 0 : (((AbstractInterval)interval).isRightClosed() ? this.getRightEndpoint().compareTo(((AbstractInterval)interval).getRightEndpoint()) > 0 : this.getRightEndpoint().compareTo(((AbstractInterval)interval).getRightEndpoint()) >= 0));
    }

    @Override
    public boolean isReverse() {
        return this._bReverse;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractInterval)) {
            return false;
        }
        AbstractInterval that = (AbstractInterval)o;
        if (this.isLeftClosed() != that.isLeftClosed()) {
            return false;
        }
        if (this.isReverse() != that.isReverse()) {
            return false;
        }
        if (this.isRightClosed() != that.isRightClosed()) {
            return false;
        }
        if (!this.getLeftEndpoint().equals(that.getLeftEndpoint())) {
            return false;
        }
        return this.getRightEndpoint().equals(that.getRightEndpoint());
    }

    public int hashCode() {
        int result = this.getLeftEndpoint().hashCode();
        result = 31 * result + this.getRightEndpoint().hashCode();
        result = 31 * result + (this.isLeftClosed() ? 1 : 0);
        result = 31 * result + (this.isRightClosed() ? 1 : 0);
        result = 31 * result + (this.isReverse() ? 1 : 0);
        return result;
    }

    public String toString() {
        if (this.isReverse()) {
            return String.valueOf(this.getRightEndpoint()) + (this.isRightClosed() ? "" : "|") + ".." + (this.isLeftClosed() ? "" : "|") + String.valueOf(this.getLeftEndpoint());
        }
        return String.valueOf(this.getLeftEndpoint()) + (this.isLeftClosed() ? "" : "|") + ".." + (this.isRightClosed() ? "" : "|") + String.valueOf(this.getRightEndpoint());
    }
}

