/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.reflect.java.asm;

import gw.lang.reflect.java.asm.AsmAnnotation;
import gw.lang.reflect.java.asm.AsmClass;
import gw.lang.reflect.java.asm.AsmType;
import gw.lang.reflect.java.asm.AsmUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AsmField {
    private String _name;
    private int _modifiers;
    private AsmType _type;
    private List<AsmAnnotation> _annotations;
    private AsmClass _owner;
    private Object _staticValue;

    public AsmField(AsmClass owner, int access, String name, String desc, Object value) {
        this._owner = owner;
        this._modifiers = access;
        this._name = name;
        this._annotations = Collections.emptyList();
        this._type = AsmUtil.makeType(desc);
        this._staticValue = value;
    }

    public String getName() {
        return this._name;
    }

    public int getModifiers() {
        return this._modifiers;
    }

    public boolean isSynthetic() {
        return (this._modifiers & 0x1000) != 0;
    }

    public boolean isEnumConstant() {
        return (this.getModifiers() & 0x4000) != 0;
    }

    public AsmType getType() {
        return this._type;
    }

    public void setType(AsmType type) {
        this._type = type;
    }

    public AsmClass getDeclaringClass() {
        return this._owner;
    }

    public List<AsmAnnotation> getAnnotations() {
        return this._annotations;
    }

    void addAnnotation(AsmAnnotation asmAnnotation) {
        if (this._annotations.isEmpty()) {
            this._annotations = new ArrayList<AsmAnnotation>(2);
        }
        this._annotations.add(asmAnnotation);
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this.getAnnotation(annotationClass) != null;
    }

    public AsmAnnotation getAnnotation(Class annotationClass) {
        for (AsmAnnotation anno : this.getAnnotations()) {
            if (!annotationClass.getName().equals(anno.getType().getName())) continue;
            return anno;
        }
        return null;
    }

    public Object getStaticValue() {
        return this._staticValue;
    }

    public String toString() {
        int mod = this.getModifiers();
        return (String)(mod == 0 ? "" : Modifier.toString(mod) + " ") + String.valueOf(this.getType()) + " " + this.getName();
    }
}

