/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.reflect.java.asm;

import gw.internal.ext.org.objectweb.asm.signature.SignatureVisitor;
import gw.lang.reflect.java.asm.AsmMethod;
import gw.lang.reflect.java.asm.AsmPrimitiveType;
import gw.lang.reflect.java.asm.AsmType;
import gw.lang.reflect.java.asm.AsmUtil;
import gw.lang.reflect.java.asm.AsmWildcardType;

public class DeclarationPartSignatureVisitor
extends SignatureVisitor {
    private AsmType _currentType;
    private AsmType _typeArg;
    private int _iArrayDims;
    private Boolean _variance;
    private AsmMethod _method;

    DeclarationPartSignatureVisitor() {
        super(458752);
    }

    DeclarationPartSignatureVisitor(AsmMethod method) {
        super(458752);
        this._method = method;
    }

    DeclarationPartSignatureVisitor(AsmMethod method, AsmType type) {
        super(458752);
        this._method = method;
        this._currentType = type;
    }

    DeclarationPartSignatureVisitor(AsmType type) {
        this(null, type);
    }

    DeclarationPartSignatureVisitor(AsmMethod method, AsmType type, char wildcardVariance) {
        this(method, type);
        this._variance = wildcardVariance == '+';
    }

    public AsmType getCurrentType() {
        return this._currentType;
    }

    public void visitFormalTypeParameter(String tv) {
        throw new IllegalStateException();
    }

    public SignatureVisitor visitClassBound() {
        throw new IllegalStateException();
    }

    public SignatureVisitor visitInterfaceBound() {
        throw new IllegalStateException();
    }

    public SignatureVisitor visitSuperclass() {
        return this;
    }

    public SignatureVisitor visitInterface() {
        throw new IllegalStateException();
    }

    public SignatureVisitor visitParameterType() {
        throw new IllegalStateException();
    }

    public SignatureVisitor visitReturnType() {
        throw new IllegalStateException();
    }

    public SignatureVisitor visitExceptionType() {
        throw new IllegalStateException();
    }

    public void visitBaseType(char c) {
        AsmType type = AsmPrimitiveType.findPrimitive(String.valueOf(c));
        if (this._iArrayDims > 0) {
            type = AsmUtil.makeType(type.getName());
        }
        if (this._currentType == null) {
            this._currentType = type;
            if (this._variance != null) {
                this._currentType = new AsmWildcardType(this._currentType, this._variance);
            }
            for (int i = 0; i < this._iArrayDims; ++i) {
                this._currentType.incArrayDims();
            }
        } else {
            this._typeArg = type;
            if (this._variance != null) {
                this._typeArg = new AsmWildcardType(this._typeArg, this._variance);
            }
            for (int i = 0; i < this._iArrayDims; ++i) {
                this._typeArg.incArrayDims();
            }
            this._currentType.addTypeParameter(this._typeArg);
        }
    }

    public void visitTypeVariable(String tv) {
        if (this._currentType == null) {
            this._currentType = AsmUtil.makeTypeVariable(tv, this.isFunctionTypeVar(tv));
            for (int i = 0; i < this._iArrayDims; ++i) {
                this._currentType.incArrayDims();
            }
            if (this._variance != null) {
                this._currentType = new AsmWildcardType(this._currentType, this._variance);
            }
        } else {
            AsmType typeArg = AsmUtil.makeTypeVariable(tv, this.isFunctionTypeVar(tv));
            for (int i = 0; i < this._iArrayDims; ++i) {
                typeArg.incArrayDims();
            }
            if (this._variance != null) {
                typeArg = new AsmWildcardType(typeArg, this._variance);
            }
            this._currentType.addTypeParameter(typeArg);
        }
    }

    private boolean isFunctionTypeVar(String tv) {
        if (this._method == null) {
            return false;
        }
        AsmType typeVar = this._method.findTypeVariable(tv);
        return typeVar != null;
    }

    public SignatureVisitor visitArrayType() {
        ++this._iArrayDims;
        return this;
    }

    public void visitClassType(String name) {
        if (this._currentType == null) {
            this._currentType = AsmUtil.makeType(name);
            if (this._variance != null) {
                this._currentType = new AsmWildcardType(this._currentType, this._variance);
            }
        } else {
            this._typeArg = AsmUtil.makeType(name);
            if (this._variance != null) {
                this._typeArg = new AsmWildcardType(this._typeArg, this._variance);
            }
        }
    }

    public void visitInnerClassType(String name) {
        if (this._currentType == null) {
            this._currentType = AsmUtil.makeType(name);
            if (this._variance != null) {
                this._currentType = new AsmWildcardType(this._currentType, this._variance);
            }
        } else if (this._typeArg != null) {
            this._typeArg = AsmUtil.makeType((this._typeArg instanceof AsmWildcardType ? ((AsmWildcardType)this._typeArg).getBound().getName() : this._typeArg.getName()) + "$" + name);
            if (this._variance != null) {
                this._typeArg = new AsmWildcardType(this._typeArg, this._variance);
            }
        } else {
            this._currentType = AsmUtil.makeType((this._currentType instanceof AsmWildcardType ? ((AsmWildcardType)this._currentType).getBound().getName() : this._currentType.getName()) + "$" + name);
            if (this._variance != null) {
                this._currentType = new AsmWildcardType(this._currentType, this._variance);
            }
        }
    }

    public void visitTypeArgument() {
        if (this._typeArg != null) {
            this._typeArg.addTypeParameter(new AsmWildcardType(null, true));
        } else {
            this._currentType.addTypeParameter(new AsmWildcardType(null, true));
        }
    }

    public SignatureVisitor visitTypeArgument(char wildcard) {
        if (wildcard != '=') {
            return new DeclarationPartSignatureVisitor(this._method, this._typeArg == null ? this._currentType : this._typeArg, wildcard);
        }
        return new DeclarationPartSignatureVisitor(this._method, this._typeArg == null ? this._currentType : this._typeArg);
    }

    public void visitEnd() {
        if (this._iArrayDims > 0) {
            if (this._typeArg != null) {
                for (int i = 0; i < this._iArrayDims; ++i) {
                    this._typeArg.incArrayDims();
                }
            } else {
                for (int i = 0; i < this._iArrayDims; ++i) {
                    this._currentType.incArrayDims();
                }
            }
        }
        if (this._typeArg != null) {
            this._currentType.addTypeParameter(this._typeArg);
        }
    }
}

