/*
 * Decompiled with CFR 0.152.
 */
package gw.util;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public abstract class DerivedKeyHashMap<K, V>
implements Map<K, V> {
    private Object[] _table;
    private int _size;

    public DerivedKeyHashMap() {
        this._table = new Object[16];
        this._size = 0;
    }

    public DerivedKeyHashMap(Collection<V> values) {
        this._table = new Object[(int)((double)values.size() / this.loadFactor())];
        this._size = 0;
        for (V value : values) {
            V existingValue = this.putImpl(this.getKeyForValue(value), value, this._table, false);
            if (existingValue == null) continue;
            ++this._size;
        }
    }

    protected int hash(Object key) {
        return key.hashCode();
    }

    protected abstract boolean keyMatches(Object var1, V var2);

    protected abstract K getKeyForValue(V var1);

    protected abstract double loadFactor();

    @Override
    public int size() {
        return this._size;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            throw new NullPointerException("containsKey on a DerivedKeyHashMap cannot be called with a null key");
        }
        return this.findValueWithMatchingKeyInChain(key, this._table[this.bucket(key, this._table.length)]) != null;
    }

    @Override
    public V get(Object key) {
        if (key == null) {
            throw new NullPointerException("get on a DerivedKeyHashMap cannot be called with a null key");
        }
        return this.findValueWithMatchingKeyInChain(key, this._table[this.bucket(key, this._table.length)]);
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            throw new NullPointerException("containsValue on a DerivedKeyHashMap cannot be called with a null argument");
        }
        for (int i = 0; i < this._table.length; ++i) {
            if (!this.hasMatchingValueInChain(value, this._table[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public V put(K key, V value) {
        if (value == null) {
            throw new IllegalArgumentException("DerivedKeyHashMaps cannot currently be used with null values");
        }
        if (!this.getKeyForValue(value).equals(key)) {
            throw new IllegalArgumentException("The derived key [" + String.valueOf(this.getKeyForValue(value)) + "] for value [" + String.valueOf(value) + "] does not match the supplied key [" + String.valueOf(key) + "]");
        }
        V existingValue = this.putImpl(key, value, this._table, true);
        if (existingValue == null) {
            ++this._size;
        }
        return existingValue;
    }

    @Override
    public V remove(Object key) {
        Object priorValue;
        block12: {
            if (key == null) {
                return null;
            }
            priorValue = null;
            int bucket = this.bucket(key, this._table.length);
            if (this._table[bucket] != null) {
                if (this._table[bucket] instanceof ChainedEntry) {
                    ChainedEntry previousLink = null;
                    ChainedEntry currentLink = (ChainedEntry)this._table[bucket];
                    while (true) {
                        if (this.keyMatches(key, currentLink._entry)) {
                            priorValue = currentLink._entry;
                            if (previousLink == null) {
                                this._table[bucket] = currentLink._next;
                            } else {
                                previousLink._next = currentLink._next;
                            }
                            break block12;
                        }
                        if (!(currentLink._next instanceof ChainedEntry)) break;
                        previousLink = currentLink;
                        currentLink = (ChainedEntry)currentLink._next;
                    }
                    if (this.keyMatches(key, currentLink._next)) {
                        priorValue = currentLink._next;
                        if (previousLink == null) {
                            this._table[bucket] = currentLink._entry;
                        } else {
                            previousLink._next = currentLink._entry;
                        }
                    }
                } else {
                    priorValue = this._table[bucket];
                    this._table[bucket] = null;
                }
            }
        }
        if (priorValue != null) {
            --this._size;
        }
        return (V)priorValue;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<Object, Object> entry : m.entrySet()) {
            if (entry.getKey() == null) {
                throw new IllegalArgumentException("Cannot add a value with a null key to a DerivedKeyHashMap");
            }
            if (entry.getValue() == null) {
                throw new IllegalArgumentException("Cannot add a null value to a DerivedKeyHashMap");
            }
            if (this.getKeyForValue(entry.getValue()).equals(entry.getKey())) continue;
            throw new IllegalArgumentException("The derived key [" + String.valueOf(this.getKeyForValue(entry.getValue())) + "] for value [" + String.valueOf(entry.getValue()) + "] does not match the supplied key [" + String.valueOf(entry.getKey()) + "]");
        }
        for (Map.Entry<Object, Object> entry : m.entrySet()) {
            V existingValue = this.putImpl(entry.getKey(), entry.getValue(), this._table, false);
            if (existingValue != null) continue;
            ++this._size;
        }
    }

    @Override
    public void clear() {
        this._table = new Object[16];
        this._size = 0;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return null;
    }

    @Override
    public Set<K> keySet() {
        return new KeySet();
    }

    @Override
    public Collection<V> values() {
        ArrayList<Object> values = new ArrayList<Object>();
        for (int i = 0; i < this._table.length; ++i) {
            if (this._table[i] == null) continue;
            if (this._table[i] instanceof ChainedEntry) {
                ChainedEntry entry = (ChainedEntry)this._table[i];
                values.add(entry._entry);
                while (entry._next instanceof ChainedEntry) {
                    entry = (ChainedEntry)entry._next;
                    values.add(entry._entry);
                }
                values.add(entry._next);
                continue;
            }
            values.add(this._table[i]);
        }
        return values;
    }

    private V findValueWithMatchingKeyInChain(Object key, Object entry) {
        if (entry == null) {
            return null;
        }
        if (entry instanceof ChainedEntry) {
            ChainedEntry chainedEntry = (ChainedEntry)entry;
            if (this.keyMatches(key, chainedEntry._entry)) {
                return chainedEntry._entry;
            }
            return this.findValueWithMatchingKeyInChain(key, chainedEntry._next);
        }
        if (this.keyMatches(key, entry)) {
            return (V)entry;
        }
        return null;
    }

    private boolean hasMatchingValueInChain(Object value, Object entry) {
        if (entry == null) {
            return false;
        }
        if (entry instanceof ChainedEntry) {
            ChainedEntry chainedEntry = (ChainedEntry)entry;
            if (chainedEntry._entry.equals(value)) {
                return true;
            }
            return this.hasMatchingValueInChain(value, chainedEntry._next);
        }
        return entry.equals(value);
    }

    private int bucket(Object key, int tableLength) {
        return Math.abs(this.hash(key) % tableLength);
    }

    public V putImpl(K key, V value, Object[] table, boolean resizeIfNecessary) {
        Object priorValue;
        block12: {
            if (key == null) {
                throw new IllegalArgumentException("Cannot add a value with a null key to a DerivedKeyHashMap");
            }
            if (value == null) {
                throw new IllegalArgumentException("Cannot add a null value to a DerivedKeyHashMap");
            }
            priorValue = null;
            int bucket = this.bucket(key, table.length);
            if (table[bucket] == null) {
                table[bucket] = value;
            } else if (table[bucket] instanceof ChainedEntry) {
                ChainedEntry lastChain = (ChainedEntry)table[bucket];
                while (true) {
                    if (this.keyMatches(key, lastChain._entry)) {
                        priorValue = lastChain._entry;
                        lastChain._entry = value;
                        break block12;
                    }
                    if (!(lastChain._next instanceof ChainedEntry)) break;
                    lastChain = (ChainedEntry)lastChain._next;
                }
                if (this.keyMatches(key, lastChain._next)) {
                    priorValue = lastChain._next;
                    lastChain._next = value;
                } else {
                    ChainedEntry<Object> newChain;
                    lastChain._next = newChain = new ChainedEntry<Object>(lastChain._next, value);
                }
            } else if (this.keyMatches(key, table[bucket])) {
                priorValue = table[bucket];
                table[bucket] = value;
            } else {
                table[bucket] = new ChainedEntry<Object>(table[bucket], value);
            }
        }
        return (V)priorValue;
    }

    private void resize(int newTableSize) {
        Object[] newTable = new Object[newTableSize];
        for (V value : this.values()) {
            this.putImpl(this.getKeyForValue(value), value, newTable, false);
        }
        this._table = newTable;
    }

    private class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public int size() {
            return DerivedKeyHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return DerivedKeyHashMap.this.containsKey(o);
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public boolean add(K k) {
            throw new UnsupportedOperationException("You cannot add directly to the key set for a Map; you must use put() on the Map instead");
        }

        @Override
        public boolean remove(Object o) {
            return DerivedKeyHashMap.this.remove(o) != null;
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            if (c == null) {
                throw new NullPointerException("containsAll(Collection) cannot be called with a null argument");
            }
            return super.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends K> c) {
            throw new UnsupportedOperationException("You cannot add directly to the key set for a Map; you must use put() on the Map instead");
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            if (c == null) {
                throw new NullPointerException("retainAll(Collection) cannot be called with a null argument");
            }
            for (Object o : c) {
                if (o != null) continue;
                throw new NullPointerException("The elements within the argument to retainAll(Collection) on the key set of a DerivedKeyHashMap cannot be null");
            }
            return super.retainAll(c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            if (c == null) {
                throw new NullPointerException("removeAll(Collection) cannot be called with a null argument");
            }
            for (Object o : c) {
                if (o != null) continue;
                throw new NullPointerException("The elements within the argument to removeAll(Collection) on the key set of a DerivedKeyHashMap cannot be null");
            }
            return super.removeAll(c);
        }

        @Override
        public void clear() {
            DerivedKeyHashMap.this.clear();
        }
    }

    private class KeyIterator
    implements Iterator<K> {
        private ValueIterator _valueIterator;

        private KeyIterator() {
            this._valueIterator = new ValueIterator();
        }

        @Override
        public boolean hasNext() {
            return this._valueIterator.hasNext();
        }

        @Override
        public K next() {
            return DerivedKeyHashMap.this.getKeyForValue(this._valueIterator.next());
        }

        @Override
        public void remove() {
            this._valueIterator.remove();
        }
    }

    private class ValueIterator
    implements Iterator<V> {
        private int _bucket = -1;
        private Object _entry = null;

        private ValueIterator() {
            this.advanceIterator();
        }

        @Override
        public boolean hasNext() {
            return this._entry != null;
        }

        @Override
        public V next() {
            if (this._entry == null) {
                throw new NoSuchElementException();
            }
            Object result = this._entry instanceof ChainedEntry ? ((ChainedEntry)this._entry)._entry : this._entry;
            this.advanceIterator();
            return result;
        }

        @Override
        public void remove() {
        }

        private void advanceIterator() {
            if (this._entry instanceof ChainedEntry) {
                this._entry = ((ChainedEntry)this._entry)._next;
            } else {
                this._entry = null;
                for (int i = this._bucket + 1; i < DerivedKeyHashMap.this._table.length; ++i) {
                    if (DerivedKeyHashMap.this._table[i] == null) continue;
                    this._bucket = i;
                    this._entry = DerivedKeyHashMap.this._table[i];
                    break;
                }
            }
        }
    }

    private static class ChainedEntry<V> {
        private V _entry;
        private Object _next;

        private ChainedEntry(V entry, Object next) {
            this._entry = entry;
            this._next = next;
        }
    }
}

