/*
 * Decompiled with CFR 0.152.
 */
package gw.util.perf.codestats;

import gw.util.perf.codestats.FileInfo;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class ProjectInfo {
    private File projectFolder;
    private Map<String, FileInfo> infos = new HashMap<String, FileInfo>();

    public ProjectInfo(String project, String[] extensions) {
        this.projectFolder = new File(project);
        for (String extension : extensions) {
            this.infos.put(extension, new FileInfo(extension));
        }
    }

    private void processFile(File fileOrFolder) {
        File[] files;
        for (File file : files = fileOrFolder.listFiles()) {
            String name = file.getName();
            if (file.isDirectory()) {
                this.processFile(file);
                continue;
            }
            try {
                String extension;
                FileInfo fileInfo;
                int beginIndex = name.lastIndexOf(46);
                if (beginIndex <= 0 || (fileInfo = this.infos.get(extension = name.substring(beginIndex))) == null) continue;
                fileInfo.process(file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void printInfo() {
        this.processFile(this.projectFolder);
        System.out.println("Stats for " + String.valueOf(this.projectFolder));
        System.out.println("===================================");
        FileInfo totals = new FileInfo(" total");
        for (String extension : this.infos.keySet()) {
            FileInfo fileInfo = this.infos.get(extension);
            fileInfo.printInfo();
            totals.add(fileInfo);
        }
        totals.printInfo();
        System.out.println();
    }

    public static void main(String[] args) {
        String[] extensions = new String[]{".java", ".gs", ".gsx"};
        new ProjectInfo("C:\\dev\\emerald\\studio\\platform\\ij-studio\\src", extensions).printInfo();
    }
}

