/*
 * Decompiled with CFR 0.152.
 */
package gw.xml.simple;

import gw.xml.simple.SimpleXmlNode;
import java.util.ArrayList;
import java.util.Collections;

public class SimpleXmlNodeWriter {
    private StringBuilder _sb = new StringBuilder();
    private int _indent = 0;

    public static String writeToString(SimpleXmlNode node) {
        SimpleXmlNodeWriter writer = new SimpleXmlNodeWriter();
        return writer.createXml(node);
    }

    private SimpleXmlNodeWriter() {
    }

    private String createXml(SimpleXmlNode node) {
        this.appendNode(node);
        this._sb.deleteCharAt(this._sb.length() - 1);
        return this._sb.toString();
    }

    private void appendNode(SimpleXmlNode node) {
        this.appendIndent();
        this._sb.append("<").append(node.getName());
        this.appendAttributes(node);
        if (node.getChildren().isEmpty()) {
            if (node.getText() == null) {
                this._sb.append("/>\n");
            } else {
                this._sb.append(">");
                this._sb.append(SimpleXmlNodeWriter.xmlEncode(node.getText(), false));
                this._sb.append("</").append(node.getName()).append(">\n");
            }
        } else {
            this._sb.append(">\n");
            this.pushIndent();
            if (node.getText() != null) {
                this.appendIndent();
                this._sb.append(SimpleXmlNodeWriter.xmlEncode(node.getText(), false)).append("\n");
            }
            this.appendChildren(node);
            this.popIndent();
            this.appendIndent();
            this._sb.append("</").append(node.getName()).append(">\n");
        }
    }

    private void appendAttributes(SimpleXmlNode node) {
        ArrayList<String> orderedKeys = new ArrayList<String>(node.getAttributes().keySet());
        Collections.sort(orderedKeys);
        for (String attribute : orderedKeys) {
            this._sb.append(" ").append(attribute).append("=").append(SimpleXmlNodeWriter.xmlEncode(node.getAttributes().get(attribute), true)).append("");
        }
    }

    private void appendChildren(SimpleXmlNode node) {
        for (SimpleXmlNode child : node.getChildren()) {
            this.appendNode(child);
        }
    }

    private void pushIndent() {
        this._indent += 2;
    }

    private void popIndent() {
        this._indent -= 2;
    }

    private void appendIndent() {
        for (int i = 0; i < this._indent; ++i) {
            this._sb.append(" ");
        }
    }

    private static String xmlEncode(String input, boolean attribute) {
        if (input == null || input.length() == 0) {
            return attribute ? "\"\"" : input;
        }
        StringBuilder output = new StringBuilder();
        if (attribute) {
            output.append(0);
        }
        int quoteChar = 0;
        block8: for (int i = 0; i < input.length(); ++i) {
            char ch = input.charAt(i);
            switch (ch) {
                case '<': {
                    output.append("&lt;");
                    continue block8;
                }
                case '>': {
                    output.append("&gt;");
                    continue block8;
                }
                case '&': {
                    output.append("&amp;");
                    continue block8;
                }
                case '\"': {
                    if (attribute && quoteChar == 34) {
                        output.append("&quot;");
                        continue block8;
                    }
                    output.append(ch);
                    quoteChar = 39;
                    continue block8;
                }
                case '\'': {
                    if (attribute && quoteChar == 39) {
                        output.append("&apos;");
                        continue block8;
                    }
                    output.append(ch);
                    quoteChar = 34;
                    continue block8;
                }
                case '\t': 
                case '\n': 
                case '\r': {
                    if (attribute) {
                        output.append("&#");
                        output.append((int)ch);
                        output.append(";");
                        continue block8;
                    }
                    output.append(ch);
                    continue block8;
                }
                default: {
                    if (ch < ' ' || ch >= '\ufffe') {
                        throw new IllegalArgumentException("UTF-16 Codepoint 0x" + Integer.toString(ch, 16) + " is not valid for XML content");
                    }
                    output.append(ch);
                }
            }
        }
        if (attribute) {
            if (quoteChar == 0) {
                quoteChar = 34;
            }
            output.setCharAt(0, (char)quoteChar);
            output.append((char)quoteChar);
        }
        return output.toString();
    }
}

