/*
 * Decompiled with CFR 0.152.
 */
package gw.xml.simple;

import gw.xml.simple.SimpleXmlNode;
import gw.xml.simple.SimpleXmlNodeHandler;
import java.io.File;
import java.io.InputStream;
import java.io.StringReader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.helpers.DefaultHandler;

public class SimpleXmlParser {
    private static ThreadLocal<SAXParser> _saxParser = new ThreadLocal();

    private SimpleXmlParser() {
    }

    public static SimpleXmlNode parseFile(File file) {
        SimpleXmlNodeHandler nodeHandler = new SimpleXmlNodeHandler();
        try {
            SimpleXmlParser.makeSAXParser().parse(file, (DefaultHandler)nodeHandler);
            return nodeHandler.getRoot();
        }
        catch (Exception e) {
            throw SimpleXmlParser.maybeWrapException(e);
        }
    }

    public static SimpleXmlNode parseInputStream(InputStream stream) {
        SimpleXmlNodeHandler nodeHandler = new SimpleXmlNodeHandler();
        try {
            SimpleXmlParser.makeSAXParser().parse(stream, (DefaultHandler)nodeHandler);
            return nodeHandler.getRoot();
        }
        catch (Exception e) {
            throw SimpleXmlParser.maybeWrapException(e);
        }
    }

    public static SimpleXmlNode parseString(String s) {
        SimpleXmlNodeHandler nodeHandler = new SimpleXmlNodeHandler();
        try {
            SimpleXmlParser.makeSAXParser().parse(new InputSource(new StringReader(s)), (DefaultHandler)nodeHandler);
            return nodeHandler.getRoot();
        }
        catch (Exception e) {
            throw SimpleXmlParser.maybeWrapException(e);
        }
    }

    private static RuntimeException maybeWrapException(Exception e) {
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return new RuntimeException(e);
    }

    private static SAXParser makeSAXParser() throws ParserConfigurationException, SAXException {
        SAXParser parser = _saxParser.get();
        if (parser != null) {
            try {
                parser.reset();
            }
            catch (UnsupportedOperationException uoe) {
                parser = null;
            }
        }
        if (parser == null) {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SimpleXmlParser.disableExternalEntities(factory);
            parser = factory.newSAXParser();
            _saxParser.set(parser);
        }
        return parser;
    }

    private static void disableExternalEntities(SAXParserFactory factory) throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException {
        factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
    }
}

