/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.parser.coercers;

import gw.lang.GosuShop;
import gw.lang.function.IBlock;
import gw.lang.parser.IResolvingCoercer;
import gw.lang.parser.coercers.BaseCoercer;
import gw.lang.reflect.IFunctionType;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.IParameterInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeInfo;
import gw.lang.reflect.ITypeVariableType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.IGenericTypeVariable;
import gw.lang.reflect.gs.IGosuClass;
import gw.lang.reflect.gs.IGosuEnhancement;
import gw.lang.reflect.gs.IGosuMethodInfo;
import gw.lang.reflect.gs.IGosuObject;
import gw.lang.reflect.java.IJavaMethodInfo;
import gw.lang.reflect.java.IJavaType;
import gw.lang.reflect.java.JavaTypes;
import java.util.ArrayList;
import java.util.Iterator;

public class FunctionToInterfaceCoercer
extends BaseCoercer
implements IResolvingCoercer {
    private static FunctionToInterfaceCoercer _instance = new FunctionToInterfaceCoercer();

    public static FunctionToInterfaceCoercer instance() {
        return _instance;
    }

    private FunctionToInterfaceCoercer() {
    }

    @Override
    public Object coerceValue(IType typeToCoerceTo, Object value) {
        if (value instanceof IBlock) {
            IGosuClass proxyClass = GosuShop.getBlockToInterfaceConversionClass(typeToCoerceTo, TypeSystem.get(value.getClass().getEnclosingClass()));
            IBlock blk = (IBlock)value;
            try {
                return proxyClass.getBackingClass().getConstructor(IBlock.class).newInstance(blk);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        throw new IllegalStateException();
    }

    public static IFunctionType getRepresentativeFunctionType(IType interfaceType) {
        IMethodInfo javaMethodInfo = FunctionToInterfaceCoercer.getSingleMethod(interfaceType);
        if (javaMethodInfo != null) {
            return GosuShop.createFunctionType(javaMethodInfo);
        }
        return null;
    }

    public static IMethodInfo getSingleMethod(IType interfaceType) {
        if (interfaceType.isInterface() && (interfaceType instanceof IJavaType || interfaceType instanceof IGosuClass)) {
            IMethodInfo mi;
            ArrayList<IMethodInfo> list = new ArrayList<IMethodInfo>(interfaceType.getTypeInfo().getMethods());
            ITypeInfo objTypeInfo = JavaTypes.OBJECT().getTypeInfo();
            Iterator it = list.iterator();
            while (it.hasNext()) {
                IMethodInfo methodInfo = (IMethodInfo)it.next();
                IParameterInfo[] parameterInfos = methodInfo.getParameters();
                IType[] paramTypes = new IType[parameterInfos.length];
                for (int i = 0; i < parameterInfos.length; ++i) {
                    paramTypes[i] = parameterInfos[i].getFeatureType();
                }
                if (objTypeInfo.getMethod(methodInfo.getDisplayName(), paramTypes) != null || methodInfo.getOwnersType() instanceof IGosuEnhancement) {
                    it.remove();
                    continue;
                }
                if (methodInfo.getOwnersType().getName().contains(IGosuObject.class.getName())) {
                    it.remove();
                    continue;
                }
                if (methodInfo.isAbstract()) continue;
                it.remove();
            }
            if (list.size() == 1 && ((mi = (IMethodInfo)list.get(0)) instanceof IJavaMethodInfo || mi instanceof IGosuMethodInfo)) {
                return mi;
            }
        }
        return null;
    }

    @Override
    public boolean isExplicitCoercion() {
        return false;
    }

    @Override
    public boolean handlesNull() {
        return false;
    }

    @Override
    public int getPriority(IType to, IType from) {
        return 2;
    }

    @Override
    public IType resolveType(IType target, IType source) {
        IFunctionType sourceFun = (IFunctionType)source;
        IType returnType = sourceFun.getReturnType();
        IType methodReturnType = this.extractReturnTypeFromInterface(target);
        if (methodReturnType instanceof ITypeVariableType) {
            IGenericTypeVariable[] typeVariables = target.getGenericTypeVariables();
            IType[] parameterizationTypes = new IType[typeVariables.length];
            for (int i = 0; i < typeVariables.length; ++i) {
                IGenericTypeVariable typeVariable = typeVariables[i];
                parameterizationTypes[i] = typeVariable.getName().equals(methodReturnType.getName()) ? returnType : target.getTypeParameters()[i];
            }
            return target.getParameterizedType(parameterizationTypes);
        }
        return target;
    }

    private IType extractReturnTypeFromInterface(IType target) {
        for (IMethodInfo methodInfo : target.getTypeInfo().getMethods()) {
            if (!methodInfo.getOwnersType().equals(target)) continue;
            return methodInfo.getReturnType();
        }
        return null;
    }
}

