/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.parser.exceptions;

import gw.config.CommonServices;
import gw.lang.parser.IExpression;
import gw.lang.parser.IFullParserState;
import gw.lang.parser.IParseIssue;
import gw.lang.parser.IParsedElement;
import gw.lang.parser.IParserPart;
import gw.lang.parser.IParserState;
import gw.lang.parser.IScriptPartId;
import gw.lang.parser.ISymbolTable;
import gw.lang.parser.expressions.IProgram;
import gw.lang.parser.resources.ResourceKey;
import gw.lang.reflect.IType;
import gw.lang.reflect.gs.IGosuClass;

public abstract class ParseIssue
extends Exception
implements IParseIssue {
    private static final String SOURCE_DELIMITER = "\nat line ";
    private static final int CONTEXT_LINES = 3;
    private Integer _lineNumber;
    private Integer _lineOffset;
    private Integer _tokenColumn;
    private Integer _tokenStart;
    private Integer _tokenEnd;
    private ResourceKey _messageKey;
    private Object[] _messageArgs;
    private ISymbolTable _symbolTable;
    private IParsedElement _parentElement;
    private String _stateSource;
    private IGosuClass _parentClass;

    private void debug() {
    }

    protected ParseIssue(IParserState parserState, ResourceKey key, Object ... msgArgs) {
        super("");
        this._messageKey = key;
        this._messageArgs = this.normalizeMessageArgs(msgArgs);
        this.initFieldsFromParserState(parserState);
        this.debug();
    }

    protected ParseIssue(Integer lineNumber, Integer lineOffset, Integer tokenColumn, Integer tokenStart, Integer tokenEnd, ISymbolTable symbolTable, ResourceKey key, Object ... msgArgs) {
        super("");
        this._messageKey = key;
        this._messageArgs = this.normalizeMessageArgs(msgArgs);
        this._symbolTable = symbolTable;
        this._lineNumber = lineNumber;
        this._lineOffset = lineOffset == null ? 1 : Math.max(1, lineOffset);
        this._tokenColumn = tokenColumn;
        this._tokenStart = tokenStart;
        this._tokenEnd = tokenEnd;
        this.debug();
    }

    protected ParseIssue(IParserState state, Throwable t) {
        super(t);
        this.initFieldsFromParserState(state);
        this.debug();
    }

    @Override
    public Throwable fillInStackTrace() {
        return this;
    }

    private void initFieldsFromParserState(IParserState parserState) {
        if (parserState != null) {
            if (parserState instanceof IFullParserState) {
                IFullParserState fullParserState = (IFullParserState)parserState;
                this._symbolTable = fullParserState.getSymbolTable();
            }
            this._lineNumber = parserState.getLineNumber();
            this._lineOffset = Math.max(1, parserState.getLineOffset());
            this._tokenColumn = parserState.getTokenColumn();
            this._tokenStart = parserState.getTokenStart();
            this._tokenEnd = parserState.getTokenEnd();
            String parserSource = parserState.getSource();
            this.setStateSource(parserSource);
        }
    }

    private Object[] normalizeMessageArgs(Object[] args) {
        Object[] result = args;
        if (args != null && args.length > 0) {
            result = new Object[args.length];
            for (int i = 0; i < args.length; ++i) {
                result[i] = args[i] == null || args[i] instanceof CharSequence || args[i] instanceof Number ? args[i] : args[i].toString();
            }
        }
        return result;
    }

    protected static String formatError(ResourceKey key, Object ... msgArgs) {
        if (key != null) {
            return CommonServices.getGosuLocalizationService().localize(key, msgArgs);
        }
        return "";
    }

    public Integer getLineNumber() {
        return this._lineNumber;
    }

    public Integer getLineOffset() {
        return this._lineOffset;
    }

    public void addLineOffset(int offset) {
        this._lineOffset = this._lineOffset + offset;
    }

    public Integer getTokenColumn() {
        return this._tokenColumn;
    }

    @Override
    public Integer getTokenEnd() {
        return this._tokenEnd;
    }

    @Override
    public Integer getTokenStart() {
        return this._tokenStart;
    }

    public String getContextString() {
        if (this.getStateSource() != null) {
            return ParseIssue.makeContextString(this._lineNumber, this.getStateSource(), this.getLineReportingOffset());
        }
        return null;
    }

    public String getContextStringNoLineNumbers() {
        if (this.getStateSource() != null) {
            return ParseIssue.makeContextString(this._lineNumber, this.getStateSource(), this.getLineReportingOffset(), false);
        }
        return null;
    }

    public String getStateSource() {
        if (this._stateSource == null) {
            return this._parentClass != null ? this._parentClass.getSourceFileHandle().getSource().getSource() : null;
        }
        return this._stateSource;
    }

    public void setStateSource(String parserSource) {
        this._stateSource = parserSource;
    }

    private String getMyMessage() {
        if (this._messageKey != null) {
            return ParseIssue.formatError(this._messageKey, this._messageArgs);
        }
        if (this.getCause() != null) {
            return this.getCause().getMessage();
        }
        return "";
    }

    @Override
    public String getPlainMessage() {
        return this.getMyMessage();
    }

    @Override
    public String getConsoleMessage() {
        StringBuilder retVal = new StringBuilder();
        retVal.append(this.getMyMessage());
        if (this._lineNumber != null) {
            retVal.append(" [line:").append(this._lineNumber - this.getLineReportingOffset()).append(" col:").append(this._tokenColumn);
            retVal.append("]");
            if (this.getStateSource() != null) {
                retVal.append(" in\n");
                retVal.append(this.getContextString());
            }
        }
        return retVal.toString();
    }

    public static String makeContextString(int lineOfError, String source, int lineReportingOffset) {
        return ParseIssue.makeContextString(lineOfError, source, lineReportingOffset, true);
    }

    private static String makeContextString(int lineOfError, String source, int lineReportingOffset, boolean showLineNumbers) {
        char c;
        int pos;
        int offset = 1;
        int minLine = Math.max(lineOfError - offset, 1);
        int maxLine = lineOfError + offset;
        int padding = maxLine <= 0 ? 1 : (int)Math.log10(maxLine) + 1;
        StringBuilder sb = new StringBuilder();
        int currentLine = 1;
        for (pos = 0; pos < source.length() && currentLine < minLine; ++pos) {
            c = source.charAt(pos);
            if (c != '\n') continue;
            ++currentLine;
        }
        if (showLineNumbers) {
            sb.append(String.format("line %1$" + padding + "s: ", currentLine - lineReportingOffset));
        }
        while (pos < source.length() && currentLine <= maxLine) {
            c = source.charAt(pos);
            if (c == '\n') {
                if (++currentLine <= maxLine) {
                    sb.append('\n');
                    if (showLineNumbers) {
                        sb.append(String.format("line %1$" + padding + "s: ", currentLine - lineReportingOffset));
                    }
                }
            } else {
                sb.append(c);
            }
            ++pos;
        }
        return sb.toString();
    }

    @Override
    public String getUIMessage() {
        int iIndex;
        String strMessage = this.getMyMessage();
        if (strMessage != null && (iIndex = strMessage.indexOf(SOURCE_DELIMITER)) >= 0) {
            strMessage = strMessage.substring(0, iIndex);
        }
        return strMessage;
    }

    @Override
    public int getLine() {
        Integer lineNumber = this.getLineNumber();
        return lineNumber == null ? -1 : lineNumber;
    }

    @Override
    public int getColumn() {
        return this.getTokenColumn();
    }

    @Override
    public IParsedElement getSource() {
        return this._parentElement;
    }

    public void setSource(IParsedElement sourceOfError) {
        this._parentElement = sourceOfError;
    }

    @Override
    public ISymbolTable getSymbolTable() {
        return this._symbolTable;
    }

    @Override
    public boolean appliesToPosition(int iPos) {
        Integer tokenStart = this.getTokenStart();
        Integer tokenEnd = this.getTokenEnd();
        return iPos >= tokenStart && iPos <= tokenEnd;
    }

    @Override
    public ResourceKey getMessageKey() {
        return this._messageKey;
    }

    @Override
    public void resolve(IParserPart parserBase) {
        if (parserBase != null) {
            IType parentType;
            IScriptPartId scriptPart = parserBase.getOwner().getScriptPart();
            IType iType = parentType = scriptPart == null ? null : scriptPart.getContainingType();
            if (parentType instanceof IGosuClass) {
                this._parentClass = (IGosuClass)parentType;
                this._stateSource = null;
            }
        }
        if (this._parentElement != null) {
            this.resetPositions();
            if (parserBase != null && !parserBase.getOwner().isEditorParser()) {
                this._parentElement = null;
                this._symbolTable = null;
            }
        }
    }

    @Override
    public void resetPositions() {
        boolean bForce;
        if (this._parentElement == null) {
            return;
        }
        boolean bl = bForce = this._parentElement instanceof IExpression && !(this._parentElement instanceof IProgram);
        if (bForce || this._lineNumber == null) {
            this._lineNumber = this._parentElement.getLineNum();
        }
        if (bForce || this._lineOffset == null) {
            this._lineOffset = this._parentElement.getLocation().getOffset() - this._parentElement.getLocation().getColumn();
        }
        if (bForce || this._tokenColumn == null) {
            this._tokenColumn = this._parentElement.getColumn();
        }
        if (bForce || this._tokenStart == null) {
            this._tokenStart = this._parentElement.getLocation().getOffset();
        }
        if (bForce || this._tokenEnd == null) {
            this._tokenEnd = this._parentElement.getLocation().getExtent() + 1;
        }
    }

    public void adjustOffset(int offset, int lineNumOffset, int columnOffset) {
        this._tokenStart = this._tokenStart + offset;
        this._tokenEnd = this._tokenEnd + offset;
        this._lineNumber = this._lineNumber + lineNumOffset;
        this._tokenColumn = this._tokenColumn + columnOffset;
    }

    public void setMessage(ResourceKey key, Object ... args) {
        this._messageKey = key;
        this._messageArgs = this.normalizeMessageArgs(args);
    }

    @Override
    public Object[] getMessageArgs() {
        return this._messageArgs;
    }

    public int getLineReportingOffset() {
        return 0;
    }

    @Override
    public IType getExpectedType() {
        return null;
    }
}

