/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.reflect;

import gw.lang.parser.ScriptabilityModifiers;
import gw.lang.parser.TypeVarToTypeMap;
import gw.lang.reflect.IAnnotatedFeatureInfo;
import gw.lang.reflect.IAnnotationInfo;
import gw.lang.reflect.IAttributedFeatureInfo;
import gw.lang.reflect.IConstructorInfo;
import gw.lang.reflect.IErrorType;
import gw.lang.reflect.IFeatureInfo;
import gw.lang.reflect.IGenericMethodInfo;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.IParameterInfo;
import gw.lang.reflect.IPropertyInfo;
import gw.lang.reflect.IScriptabilityModifier;
import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeInfo;
import gw.lang.reflect.ITypeRef;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.IGenericTypeVariable;
import gw.lang.reflect.java.JavaTypes;
import gw.util.GosuCollectionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

public abstract class BaseFeatureInfo
implements IAttributedFeatureInfo {
    private transient IType _intrType;
    private transient IFeatureInfo _container;
    private volatile List<IAnnotationInfo> _deprecated;
    private volatile transient List<IAnnotationInfo> _annotations;
    private volatile transient Boolean _internalAPI;

    static <T> List<T> compactAndLockList(List<T> list) {
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        if (list.size() == 1) {
            return Collections.singletonList(list.get(0));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    protected Collection<BaseFeatureInfo> getSuperAnnotatedElements() {
        IType[] interfaces;
        ArrayList<BaseFeatureInfo> infos = new ArrayList<BaseFeatureInfo>();
        this.addAnnotationSuperElement(infos, this.getOwnersType().getSupertype());
        if (!(this instanceof IConstructorInfo) && (interfaces = this.getOwnersType().getInterfaces()) != null) {
            for (IType anInterface : interfaces) {
                if (TypeSystem.isDeleted(anInterface)) continue;
                this.addAnnotationSuperElement(infos, anInterface);
            }
        }
        return infos;
    }

    private void addAnnotationSuperElement(List<BaseFeatureInfo> infos, IType type) {
        if (type != null && !(type instanceof IErrorType)) {
            IAnnotatedFeatureInfo featureInfo;
            if (this instanceof IConstructorInfo) {
                featureInfo = type.getTypeInfo().getConstructor(BaseFeatureInfo.getParamTypes(((IConstructorInfo)((Object)this)).getParameters()));
            } else if (this instanceof IMethodInfo) {
                featureInfo = type.getTypeInfo().getMethod(this.getDisplayName(), BaseFeatureInfo.getParamTypes(((IMethodInfo)((Object)this)).getParameters()));
            } else if (this instanceof IPropertyInfo) {
                featureInfo = type.getTypeInfo().getProperty(this.getName());
            } else {
                assert (this instanceof ITypeInfo);
                featureInfo = type.getTypeInfo();
            }
            if (featureInfo != null && featureInfo instanceof BaseFeatureInfo) {
                BaseFeatureInfo baseFeatureInfo = (BaseFeatureInfo)featureInfo;
                infos.add(baseFeatureInfo);
            }
        }
    }

    public static IType[] getParamTypes(IParameterInfo[] parameters) {
        ArrayList<IType> retValue = new ArrayList<IType>();
        if (parameters != null) {
            for (IParameterInfo parameterInfo : parameters) {
                retValue.add(parameterInfo.getFeatureType());
            }
        }
        return retValue.toArray(new IType[retValue.size()]);
    }

    public BaseFeatureInfo(IFeatureInfo container) {
        this._container = container;
    }

    public BaseFeatureInfo(IType intrType) {
        this._intrType = intrType;
    }

    @Override
    public IFeatureInfo getContainer() {
        return this._container;
    }

    @Override
    public String getDisplayName() {
        return this.getName();
    }

    @Override
    public String getDescription() {
        return this.getName();
    }

    @Override
    public IType getOwnersType() {
        if (this._intrType != null) {
            return this._intrType;
        }
        IFeatureInfo container = this.getContainer();
        return container != null ? container.getOwnersType() : null;
    }

    @Override
    public List<IAnnotationInfo> getAnnotationsOfType(IType type) {
        return ANNOTATION_HELPER.getAnnotationsOfType(type, this.getAnnotations());
    }

    @Override
    public boolean hasAnnotation(IType type) {
        return ANNOTATION_HELPER.hasAnnotation(type, this.getAnnotations());
    }

    @Override
    public IAnnotationInfo getAnnotation(IType type) {
        return ANNOTATION_HELPER.getAnnotation(type, this.getAnnotations(), type.getName());
    }

    @Override
    public boolean hasDeclaredAnnotation(IType type) {
        return ANNOTATION_HELPER.hasAnnotation(type, this.getDeclaredAnnotations());
    }

    @Override
    public List<IAnnotationInfo> getAnnotations() {
        if (this._annotations == null) {
            TypeSystem.lock();
            try {
                if (this._annotations == null) {
                    ArrayList<IAnnotationInfo> annotations = new ArrayList<IAnnotationInfo>();
                    this.addAnnotations(annotations, this, new IdentityHashMap());
                    this._annotations = GosuCollectionUtil.compactAndLockList(annotations);
                }
            }
            finally {
                TypeSystem.unlock();
            }
        }
        return this._annotations;
    }

    private void addAnnotations(List<IAnnotationInfo> annotations, BaseFeatureInfo fi, Map visitedFeatures) {
        if (!visitedFeatures.containsKey(fi)) {
            for (IAnnotationInfo annotationInfo : fi.getDeclaredAnnotations()) {
                if (fi != this && (!ANNOTATION_HELPER.isInherited(annotationInfo.getType()) || !ANNOTATION_HELPER.shouldAddInheritedAnnotation(this, annotations, annotationInfo))) continue;
                if (annotationInfo == null) {
                    throw new NullPointerException("Null annotation found on " + fi + " on " + fi.getOwnersType());
                }
                annotations.add(annotationInfo);
            }
            visitedFeatures.put(fi, null);
            for (BaseFeatureInfo baseFeatureInfo : fi.getSuperAnnotatedElements()) {
                this.addAnnotations(annotations, baseFeatureInfo, visitedFeatures);
            }
        }
    }

    @Override
    public boolean isVisible(IScriptabilityModifier constraint) {
        return !this.isInternalAPI();
    }

    @Override
    public boolean isScriptable() {
        return this.isVisible(ScriptabilityModifiers.SCRIPTABLE);
    }

    @Override
    public boolean isHidden() {
        try {
            return this.isInternalAPI();
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isInternalAPI() {
        if (this._internalAPI == null) {
            TypeSystem.lock();
            try {
                if (this._internalAPI == null) {
                    this._internalAPI = !this.getAnnotationsOfType(JavaTypes.INTERNAL_API()).isEmpty();
                }
                assert (this._internalAPI != null);
            }
            finally {
                TypeSystem.unlock();
            }
        }
        return this._internalAPI;
    }

    @Override
    public boolean isAbstract() {
        return false;
    }

    @Override
    public boolean isFinal() {
        return false;
    }

    @Override
    public boolean isDefaultImpl() {
        return false;
    }

    @Override
    public boolean isDeprecated() {
        return !this.getDeprecatedAnnotation().isEmpty();
    }

    @Override
    public String getDeprecatedReason() {
        List<IAnnotationInfo> annotation = this.getDeprecatedAnnotation();
        if (annotation.isEmpty()) {
            return null;
        }
        return (String)annotation.get(0).getFieldValue("value");
    }

    private List<IAnnotationInfo> getDeprecatedAnnotation() {
        if (this._deprecated == null) {
            TypeSystem.lock();
            try {
                if (this._deprecated == null) {
                    IType container;
                    IType iType = container = this._intrType == null ? this.getContainer().getOwnersType() : this._intrType;
                    this._deprecated = container instanceof ITypeRef ? this.getAnnotationsOfType(TypeSystem.getByFullName("gw.lang.Deprecated", container.getTypeLoader().getModule().getExecutionEnvironment().getGlobalModule())) : Collections.emptyList();
                }
            }
            finally {
                TypeSystem.unlock();
            }
        }
        return this._deprecated;
    }

    @Override
    public boolean isPrivate() {
        return false;
    }

    @Override
    public boolean isInternal() {
        return false;
    }

    @Override
    public boolean isProtected() {
        return false;
    }

    @Override
    public boolean isPublic() {
        return true;
    }

    public IType getActualTypeInContainer(IFeatureInfo container, IType type) {
        IType ownerType = container.getOwnersType();
        if (ownerType.isParameterizedType()) {
            TypeVarToTypeMap actualParamByVarName = TypeSystem.mapTypeByVarName(ownerType, ownerType);
            if (container instanceof IGenericMethodInfo) {
                for (IGenericTypeVariable tv : ((IGenericMethodInfo)((Object)container)).getTypeVariables()) {
                    if (actualParamByVarName.isEmpty()) {
                        actualParamByVarName = new TypeVarToTypeMap();
                    }
                    actualParamByVarName.put(tv.getTypeVariableDefinition().getType(), tv.getTypeVariableDefinition().getType());
                }
                type = TypeSystem.getActualType(type, actualParamByVarName, true);
            }
        }
        return type;
    }

    public String toString() {
        return this.getName();
    }
}

