/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.reflect;

import gw.lang.reflect.BaseFeatureInfo;
import gw.lang.reflect.IAnnotationInfo;
import gw.lang.reflect.IFeatureInfo;
import gw.lang.reflect.ILocationAwareFeature;
import gw.lang.reflect.IPresentationInfo;
import gw.lang.reflect.IPropertyAccessor;
import gw.lang.reflect.IPropertyInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.LocationInfo;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.java.IJavaClassInfo;
import gw.lang.reflect.java.IJavaClassMethod;
import gw.lang.reflect.java.IJavaType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class PropertyInfoBuilder {
    private boolean _isStatic;
    private String _name;
    private IPropertyAccessor _accessor;
    private boolean _readable = true;
    private boolean _writable = true;
    private IType _type;
    private String _description;
    private String _deprecated;
    private String _javaGetterMethodName;
    private List<IAnnotationInfo> _annotations = Collections.emptyList();
    private LocationInfo _locationInfo;

    public PropertyInfoBuilder withName(String name) {
        this._name = name;
        return this;
    }

    public PropertyInfoBuilder withType(IType type) {
        this._type = type;
        return this;
    }

    public PropertyInfoBuilder withType(Class returnType) {
        return this.withType(TypeSystem.get(returnType));
    }

    public PropertyInfoBuilder withStatic() {
        return this.withStatic(true);
    }

    public PropertyInfoBuilder withStatic(boolean isStatic) {
        this._isStatic = isStatic;
        return this;
    }

    public PropertyInfoBuilder withAccessor(IPropertyAccessor accessor) {
        this._accessor = accessor;
        return this;
    }

    public PropertyInfoBuilder withGetter(String javaGetterMethodName) {
        this._javaGetterMethodName = javaGetterMethodName;
        return this;
    }

    public PropertyInfoBuilder withReadable(boolean readable) {
        this._readable = readable;
        return this;
    }

    public PropertyInfoBuilder withWritable(boolean writable) {
        this._writable = writable;
        return this;
    }

    public PropertyInfoBuilder withDescription(String description) {
        this._description = description;
        return this;
    }

    public PropertyInfoBuilder withDeprecated(String deprecated) {
        this._deprecated = deprecated;
        return this;
    }

    public IPropertyInfo build(IFeatureInfo container) {
        return new BuiltPropertyInfo(this, container);
    }

    public PropertyInfoBuilder withAnnotations(IAnnotationInfo ... annotations) {
        this._annotations = Arrays.asList(annotations);
        return this;
    }

    public PropertyInfoBuilder like(IPropertyInfo prop) {
        this._isStatic = prop.isStatic();
        this._name = prop.getName();
        this._accessor = prop.getAccessor();
        this._readable = prop.isReadable();
        this._writable = prop.isWritable();
        this._type = prop.getFeatureType();
        this._description = prop.getDescription();
        this._deprecated = prop.isDeprecated() ? (prop.getDeprecatedReason() == null ? "" : prop.getDeprecatedReason()) : null;
        this._annotations = prop.getAnnotations();
        if (prop instanceof ILocationAwareFeature) {
            ILocationAwareFeature locationAwareFeature = (ILocationAwareFeature)((Object)prop);
            this._locationInfo = locationAwareFeature.getLocationInfo();
        }
        return this;
    }

    public PropertyInfoBuilder withLocation(LocationInfo locationInfo) {
        this._locationInfo = locationInfo;
        return this;
    }

    public static class BuiltPropertyInfo
    extends BaseFeatureInfo
    implements IPropertyInfo,
    ILocationAwareFeature {
        private final boolean _isStatic;
        private final String _name;
        private final String _javaGetterMethodName;
        private IPropertyAccessor _accessor;
        private boolean _readable = true;
        private final boolean _writable;
        private IType _type;
        private final String _description;
        private final String _deprecated;
        private List<IAnnotationInfo> _annotations = Collections.emptyList();
        private final LocationInfo _locationInfo;

        public BuiltPropertyInfo(PropertyInfoBuilder builder, IFeatureInfo container) {
            super(container);
            assert (container != null);
            this._isStatic = builder._isStatic;
            this._name = builder._name;
            this._accessor = builder._accessor;
            this._javaGetterMethodName = builder._javaGetterMethodName;
            this._readable = builder._readable;
            this._writable = builder._writable;
            this._type = builder._type;
            this._description = builder._description;
            this._deprecated = builder._deprecated;
            this._annotations = builder._annotations;
            this._locationInfo = builder._locationInfo;
            this.inferAccessorAndTypeFromName();
            assert (this._accessor != null);
            assert (this._type != null);
        }

        public String getJavaMethodName() {
            return this._javaGetterMethodName;
        }

        private void inferAccessorAndTypeFromName() {
            IType ownerType;
            if (this._accessor == null && (this._type == null || this._type instanceof IJavaType) && (ownerType = this.getOwnersType()) instanceof IJavaType) {
                IJavaClassMethod compiletimeGetter;
                Method runtimeGetter;
                IJavaType propertyType = (IJavaType)this._type;
                if (this._javaGetterMethodName != null) {
                    try {
                        runtimeGetter = ((IJavaType)ownerType).getBackingClass().getMethod(this._javaGetterMethodName, new Class[0]);
                        compiletimeGetter = ((IJavaType)ownerType).getBackingClassInfo().getMethod(this._javaGetterMethodName, new IJavaClassInfo[0]);
                    }
                    catch (NoSuchMethodException e) {
                        throw new RuntimeException(e);
                    }
                }
                try {
                    runtimeGetter = ((IJavaType)ownerType).getBackingClass().getMethod("get" + this._name, new Class[0]);
                    compiletimeGetter = ((IJavaType)ownerType).getBackingClassInfo().getMethod("get" + this._name, new IJavaClassInfo[0]);
                }
                catch (NoSuchMethodException e) {
                    try {
                        runtimeGetter = ((IJavaType)ownerType).getBackingClass().getMethod("is" + this._name, new Class[0]);
                        compiletimeGetter = ((IJavaType)ownerType).getBackingClassInfo().getMethod("is" + this._name, new IJavaClassInfo[0]);
                    }
                    catch (NoSuchMethodException e1) {
                        throw new RuntimeException(e1);
                    }
                }
                if (propertyType == null) {
                    propertyType = (IJavaType)compiletimeGetter.getReturnType();
                    this._type = propertyType;
                }
                Method setter = null;
                if (this._writable) {
                    try {
                        setter = ((IJavaType)ownerType).getBackingClass().getMethod("set" + this._name, propertyType.getIntrinsicClass());
                    }
                    catch (NoSuchMethodException e) {
                        throw new RuntimeException(e);
                    }
                }
                final Method getter1 = runtimeGetter;
                final Method setter1 = setter;
                this._accessor = new IPropertyAccessor(){

                    @Override
                    public Object getValue(Object ctx) {
                        try {
                            return getter1.invoke(ctx, new Object[0]);
                        }
                        catch (IllegalAccessException e) {
                            throw new RuntimeException(e);
                        }
                        catch (InvocationTargetException e) {
                            throw new RuntimeException(e);
                        }
                    }

                    @Override
                    public void setValue(Object ctx, Object value) {
                        try {
                            setter1.invoke(ctx, value);
                        }
                        catch (IllegalAccessException e) {
                            throw new RuntimeException(e);
                        }
                        catch (InvocationTargetException e) {
                            throw new RuntimeException(e);
                        }
                    }
                };
            }
        }

        @Override
        public List<IAnnotationInfo> getDeclaredAnnotations() {
            return this._annotations;
        }

        @Override
        public boolean isStatic() {
            return this._isStatic;
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public boolean isReadable() {
            return this._readable;
        }

        @Override
        public boolean isWritable(IType whosAskin) {
            return this._writable;
        }

        @Override
        public boolean isWritable() {
            return this.isWritable(null);
        }

        @Override
        public IPropertyAccessor getAccessor() {
            return this._accessor;
        }

        @Override
        public IPresentationInfo getPresentationInfo() {
            return IPresentationInfo.Default.GET;
        }

        @Override
        public IType getFeatureType() {
            return this._type;
        }

        @Override
        public String getDescription() {
            return this._description;
        }

        @Override
        public boolean isDeprecated() {
            return this._deprecated != null;
        }

        @Override
        public String getDeprecatedReason() {
            return this._deprecated;
        }

        @Override
        public String toString() {
            return this._name;
        }

        @Override
        public LocationInfo getLocationInfo() {
            return this._locationInfo;
        }
    }
}

